<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringPaymentProcessParameters StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecurringPaymentProcessParameters
 * @subpackage Structs
 */
class RecurringPaymentProcessParameters extends PaymentProccessParameters
{
    /**
     * The FrequencyInterval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FrequencyInterval;
    /**
     * The FrequencyTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FrequencyTypeId;
    /**
     * The PaymentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentCount;
    /**
     * The SendEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendEmail;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The UseExistingCreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseExistingCreditCard;
    /**
     * Constructor method for RecurringPaymentProcessParameters
     * @uses RecurringPaymentProcessParameters::setFrequencyInterval()
     * @uses RecurringPaymentProcessParameters::setFrequencyTypeId()
     * @uses RecurringPaymentProcessParameters::setPaymentCount()
     * @uses RecurringPaymentProcessParameters::setSendEmail()
     * @uses RecurringPaymentProcessParameters::setStartDate()
     * @uses RecurringPaymentProcessParameters::setUseExistingCreditCard()
     * @param int $frequencyInterval
     * @param int $frequencyTypeId
     * @param int $paymentCount
     * @param bool $sendEmail
     * @param string $startDate
     * @param bool $useExistingCreditCard
     */
    public function __construct($frequencyInterval = null, $frequencyTypeId = null, $paymentCount = null, $sendEmail = null, $startDate = null, $useExistingCreditCard = null)
    {
        $this
            ->setFrequencyInterval($frequencyInterval)
            ->setFrequencyTypeId($frequencyTypeId)
            ->setPaymentCount($paymentCount)
            ->setSendEmail($sendEmail)
            ->setStartDate($startDate)
            ->setUseExistingCreditCard($useExistingCreditCard);
    }
    /**
     * Get FrequencyInterval value
     * @return int|null
     */
    public function getFrequencyInterval()
    {
        return $this->FrequencyInterval;
    }
    /**
     * Set FrequencyInterval value
     * @param int $frequencyInterval
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setFrequencyInterval($frequencyInterval = null)
    {
        // validation for constraint: int
        if (!is_null($frequencyInterval) && !is_numeric($frequencyInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($frequencyInterval)), __LINE__);
        }
        $this->FrequencyInterval = $frequencyInterval;
        return $this;
    }
    /**
     * Get FrequencyTypeId value
     * @return int|null
     */
    public function getFrequencyTypeId()
    {
        return $this->FrequencyTypeId;
    }
    /**
     * Set FrequencyTypeId value
     * @param int $frequencyTypeId
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setFrequencyTypeId($frequencyTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($frequencyTypeId) && !is_numeric($frequencyTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($frequencyTypeId)), __LINE__);
        }
        $this->FrequencyTypeId = $frequencyTypeId;
        return $this;
    }
    /**
     * Get PaymentCount value
     * @return int|null
     */
    public function getPaymentCount()
    {
        return $this->PaymentCount;
    }
    /**
     * Set PaymentCount value
     * @param int $paymentCount
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setPaymentCount($paymentCount = null)
    {
        // validation for constraint: int
        if (!is_null($paymentCount) && !is_numeric($paymentCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentCount)), __LINE__);
        }
        $this->PaymentCount = $paymentCount;
        return $this;
    }
    /**
     * Get SendEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendEmail()
    {
        return isset($this->SendEmail) ? $this->SendEmail : null;
    }
    /**
     * Set SendEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendEmail
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendEmail)), __LINE__);
        }
        if (is_null($sendEmail) || (is_array($sendEmail) && empty($sendEmail))) {
            unset($this->SendEmail);
        } else {
            $this->SendEmail = $sendEmail;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get UseExistingCreditCard value
     * @return bool|null
     */
    public function getUseExistingCreditCard()
    {
        return $this->UseExistingCreditCard;
    }
    /**
     * Set UseExistingCreditCard value
     * @param bool $useExistingCreditCard
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public function setUseExistingCreditCard($useExistingCreditCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($useExistingCreditCard) && !is_bool($useExistingCreditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useExistingCreditCard)), __LINE__);
        }
        $this->UseExistingCreditCard = $useExistingCreditCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurringPaymentProcessParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
