<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringPayment StructType
 * @subpackage Structs
 */
class RecurringPayment extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The paymentParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecurringPaymentProcessParameters
     */
    public $paymentParameters;
    /**
     * Constructor method for RecurringPayment
     * @uses RecurringPayment::setAuthInfo()
     * @uses RecurringPayment::setPaymentParameters()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param \StructType\RecurringPaymentProcessParameters $paymentParameters
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, \StructType\RecurringPaymentProcessParameters $paymentParameters = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setPaymentParameters($paymentParameters);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\RecurringPayment
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get paymentParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecurringPaymentProcessParameters|null
     */
    public function getPaymentParameters()
    {
        return isset($this->paymentParameters) ? $this->paymentParameters : null;
    }
    /**
     * Set paymentParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecurringPaymentProcessParameters $paymentParameters
     * @return \StructType\RecurringPayment
     */
    public function setPaymentParameters(\StructType\RecurringPaymentProcessParameters $paymentParameters = null)
    {
        if (is_null($paymentParameters) || (is_array($paymentParameters) && empty($paymentParameters))) {
            unset($this->paymentParameters);
        } else {
            $this->paymentParameters = $paymentParameters;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurringPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
