<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProccessResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentProccessResult
 * @subpackage Structs
 */
class PaymentProccessResult extends AbstractStructBase
{
    /**
     * The AuthCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthCode;
    /**
     * The BankCommAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BankCommAmount;
    /**
     * The BankCommRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BankCommRate;
    /**
     * The BankErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankErrorCode;
    /**
     * The BankMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankMessage;
    /**
     * The BankResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankResults;
    /**
     * The BankServiceCommAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BankServiceCommAmount;
    /**
     * The BankServiceCommRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BankServiceCommRate;
    /**
     * The BonusText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BonusText;
    /**
     * The CardBin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CardBinInfo
     */
    public $CardBin;
    /**
     * The ClientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReferenceCode;
    /**
     * The CustomerCommAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CustomerCommAmount;
    /**
     * The CustomerCommApplyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerCommApplyType;
    /**
     * The CustomerCommRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CustomerCommRate;
    /**
     * The HostKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HostKey;
    /**
     * The InternalMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalMessage;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The ReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceCode;
    /**
     * Constructor method for PaymentProccessResult
     * @uses PaymentProccessResult::setAuthCode()
     * @uses PaymentProccessResult::setBankCommAmount()
     * @uses PaymentProccessResult::setBankCommRate()
     * @uses PaymentProccessResult::setBankErrorCode()
     * @uses PaymentProccessResult::setBankMessage()
     * @uses PaymentProccessResult::setBankResults()
     * @uses PaymentProccessResult::setBankServiceCommAmount()
     * @uses PaymentProccessResult::setBankServiceCommRate()
     * @uses PaymentProccessResult::setBonusText()
     * @uses PaymentProccessResult::setCardBin()
     * @uses PaymentProccessResult::setClientReferenceCode()
     * @uses PaymentProccessResult::setCustomerCommAmount()
     * @uses PaymentProccessResult::setCustomerCommApplyType()
     * @uses PaymentProccessResult::setCustomerCommRate()
     * @uses PaymentProccessResult::setHostKey()
     * @uses PaymentProccessResult::setInternalMessage()
     * @uses PaymentProccessResult::setIsSuccess()
     * @uses PaymentProccessResult::setReferenceCode()
     * @param string $authCode
     * @param float $bankCommAmount
     * @param float $bankCommRate
     * @param string $bankErrorCode
     * @param string $bankMessage
     * @param string $bankResults
     * @param float $bankServiceCommAmount
     * @param float $bankServiceCommRate
     * @param string $bonusText
     * @param \StructType\CardBinInfo $cardBin
     * @param string $clientReferenceCode
     * @param float $customerCommAmount
     * @param int $customerCommApplyType
     * @param float $customerCommRate
     * @param string $hostKey
     * @param string $internalMessage
     * @param bool $isSuccess
     * @param string $referenceCode
     */
    public function __construct($authCode = null, $bankCommAmount = null, $bankCommRate = null, $bankErrorCode = null, $bankMessage = null, $bankResults = null, $bankServiceCommAmount = null, $bankServiceCommRate = null, $bonusText = null, \StructType\CardBinInfo $cardBin = null, $clientReferenceCode = null, $customerCommAmount = null, $customerCommApplyType = null, $customerCommRate = null, $hostKey = null, $internalMessage = null, $isSuccess = null, $referenceCode = null)
    {
        $this
            ->setAuthCode($authCode)
            ->setBankCommAmount($bankCommAmount)
            ->setBankCommRate($bankCommRate)
            ->setBankErrorCode($bankErrorCode)
            ->setBankMessage($bankMessage)
            ->setBankResults($bankResults)
            ->setBankServiceCommAmount($bankServiceCommAmount)
            ->setBankServiceCommRate($bankServiceCommRate)
            ->setBonusText($bonusText)
            ->setCardBin($cardBin)
            ->setClientReferenceCode($clientReferenceCode)
            ->setCustomerCommAmount($customerCommAmount)
            ->setCustomerCommApplyType($customerCommApplyType)
            ->setCustomerCommRate($customerCommRate)
            ->setHostKey($hostKey)
            ->setInternalMessage($internalMessage)
            ->setIsSuccess($isSuccess)
            ->setReferenceCode($referenceCode);
    }
    /**
     * Get AuthCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthCode()
    {
        return isset($this->AuthCode) ? $this->AuthCode : null;
    }
    /**
     * Set AuthCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authCode
     * @return \StructType\PaymentProccessResult
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        if (is_null($authCode) || (is_array($authCode) && empty($authCode))) {
            unset($this->AuthCode);
        } else {
            $this->AuthCode = $authCode;
        }
        return $this;
    }
    /**
     * Get BankCommAmount value
     * @return float|null
     */
    public function getBankCommAmount()
    {
        return $this->BankCommAmount;
    }
    /**
     * Set BankCommAmount value
     * @param float $bankCommAmount
     * @return \StructType\PaymentProccessResult
     */
    public function setBankCommAmount($bankCommAmount = null)
    {
        $this->BankCommAmount = $bankCommAmount;
        return $this;
    }
    /**
     * Get BankCommRate value
     * @return float|null
     */
    public function getBankCommRate()
    {
        return $this->BankCommRate;
    }
    /**
     * Set BankCommRate value
     * @param float $bankCommRate
     * @return \StructType\PaymentProccessResult
     */
    public function setBankCommRate($bankCommRate = null)
    {
        $this->BankCommRate = $bankCommRate;
        return $this;
    }
    /**
     * Get BankErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankErrorCode()
    {
        return isset($this->BankErrorCode) ? $this->BankErrorCode : null;
    }
    /**
     * Set BankErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankErrorCode
     * @return \StructType\PaymentProccessResult
     */
    public function setBankErrorCode($bankErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankErrorCode) && !is_string($bankErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankErrorCode)), __LINE__);
        }
        if (is_null($bankErrorCode) || (is_array($bankErrorCode) && empty($bankErrorCode))) {
            unset($this->BankErrorCode);
        } else {
            $this->BankErrorCode = $bankErrorCode;
        }
        return $this;
    }
    /**
     * Get BankMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankMessage()
    {
        return isset($this->BankMessage) ? $this->BankMessage : null;
    }
    /**
     * Set BankMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankMessage
     * @return \StructType\PaymentProccessResult
     */
    public function setBankMessage($bankMessage = null)
    {
        // validation for constraint: string
        if (!is_null($bankMessage) && !is_string($bankMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankMessage)), __LINE__);
        }
        if (is_null($bankMessage) || (is_array($bankMessage) && empty($bankMessage))) {
            unset($this->BankMessage);
        } else {
            $this->BankMessage = $bankMessage;
        }
        return $this;
    }
    /**
     * Get BankResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankResults()
    {
        return isset($this->BankResults) ? $this->BankResults : null;
    }
    /**
     * Set BankResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankResults
     * @return \StructType\PaymentProccessResult
     */
    public function setBankResults($bankResults = null)
    {
        // validation for constraint: string
        if (!is_null($bankResults) && !is_string($bankResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankResults)), __LINE__);
        }
        if (is_null($bankResults) || (is_array($bankResults) && empty($bankResults))) {
            unset($this->BankResults);
        } else {
            $this->BankResults = $bankResults;
        }
        return $this;
    }
    /**
     * Get BankServiceCommAmount value
     * @return float|null
     */
    public function getBankServiceCommAmount()
    {
        return $this->BankServiceCommAmount;
    }
    /**
     * Set BankServiceCommAmount value
     * @param float $bankServiceCommAmount
     * @return \StructType\PaymentProccessResult
     */
    public function setBankServiceCommAmount($bankServiceCommAmount = null)
    {
        $this->BankServiceCommAmount = $bankServiceCommAmount;
        return $this;
    }
    /**
     * Get BankServiceCommRate value
     * @return float|null
     */
    public function getBankServiceCommRate()
    {
        return $this->BankServiceCommRate;
    }
    /**
     * Set BankServiceCommRate value
     * @param float $bankServiceCommRate
     * @return \StructType\PaymentProccessResult
     */
    public function setBankServiceCommRate($bankServiceCommRate = null)
    {
        $this->BankServiceCommRate = $bankServiceCommRate;
        return $this;
    }
    /**
     * Get BonusText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBonusText()
    {
        return isset($this->BonusText) ? $this->BonusText : null;
    }
    /**
     * Set BonusText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bonusText
     * @return \StructType\PaymentProccessResult
     */
    public function setBonusText($bonusText = null)
    {
        // validation for constraint: string
        if (!is_null($bonusText) && !is_string($bonusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bonusText)), __LINE__);
        }
        if (is_null($bonusText) || (is_array($bonusText) && empty($bonusText))) {
            unset($this->BonusText);
        } else {
            $this->BonusText = $bonusText;
        }
        return $this;
    }
    /**
     * Get CardBin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CardBinInfo|null
     */
    public function getCardBin()
    {
        return isset($this->CardBin) ? $this->CardBin : null;
    }
    /**
     * Set CardBin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CardBinInfo $cardBin
     * @return \StructType\PaymentProccessResult
     */
    public function setCardBin(\StructType\CardBinInfo $cardBin = null)
    {
        if (is_null($cardBin) || (is_array($cardBin) && empty($cardBin))) {
            unset($this->CardBin);
        } else {
            $this->CardBin = $cardBin;
        }
        return $this;
    }
    /**
     * Get ClientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->ClientReferenceCode) ? $this->ClientReferenceCode : null;
    }
    /**
     * Set ClientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\PaymentProccessResult
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->ClientReferenceCode);
        } else {
            $this->ClientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Get CustomerCommAmount value
     * @return float|null
     */
    public function getCustomerCommAmount()
    {
        return $this->CustomerCommAmount;
    }
    /**
     * Set CustomerCommAmount value
     * @param float $customerCommAmount
     * @return \StructType\PaymentProccessResult
     */
    public function setCustomerCommAmount($customerCommAmount = null)
    {
        $this->CustomerCommAmount = $customerCommAmount;
        return $this;
    }
    /**
     * Get CustomerCommApplyType value
     * @return int|null
     */
    public function getCustomerCommApplyType()
    {
        return $this->CustomerCommApplyType;
    }
    /**
     * Set CustomerCommApplyType value
     * @param int $customerCommApplyType
     * @return \StructType\PaymentProccessResult
     */
    public function setCustomerCommApplyType($customerCommApplyType = null)
    {
        // validation for constraint: int
        if (!is_null($customerCommApplyType) && !is_numeric($customerCommApplyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerCommApplyType)), __LINE__);
        }
        $this->CustomerCommApplyType = $customerCommApplyType;
        return $this;
    }
    /**
     * Get CustomerCommRate value
     * @return float|null
     */
    public function getCustomerCommRate()
    {
        return $this->CustomerCommRate;
    }
    /**
     * Set CustomerCommRate value
     * @param float $customerCommRate
     * @return \StructType\PaymentProccessResult
     */
    public function setCustomerCommRate($customerCommRate = null)
    {
        $this->CustomerCommRate = $customerCommRate;
        return $this;
    }
    /**
     * Get HostKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHostKey()
    {
        return isset($this->HostKey) ? $this->HostKey : null;
    }
    /**
     * Set HostKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hostKey
     * @return \StructType\PaymentProccessResult
     */
    public function setHostKey($hostKey = null)
    {
        // validation for constraint: string
        if (!is_null($hostKey) && !is_string($hostKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostKey)), __LINE__);
        }
        if (is_null($hostKey) || (is_array($hostKey) && empty($hostKey))) {
            unset($this->HostKey);
        } else {
            $this->HostKey = $hostKey;
        }
        return $this;
    }
    /**
     * Get InternalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalMessage()
    {
        return isset($this->InternalMessage) ? $this->InternalMessage : null;
    }
    /**
     * Set InternalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalMessage
     * @return \StructType\PaymentProccessResult
     */
    public function setInternalMessage($internalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($internalMessage) && !is_string($internalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalMessage)), __LINE__);
        }
        if (is_null($internalMessage) || (is_array($internalMessage) && empty($internalMessage))) {
            unset($this->InternalMessage);
        } else {
            $this->InternalMessage = $internalMessage;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\PaymentProccessResult
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get ReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceCode()
    {
        return isset($this->ReferenceCode) ? $this->ReferenceCode : null;
    }
    /**
     * Set ReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceCode
     * @return \StructType\PaymentProccessResult
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($referenceCode) && !is_string($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceCode)), __LINE__);
        }
        if (is_null($referenceCode) || (is_array($referenceCode) && empty($referenceCode))) {
            unset($this->ReferenceCode);
        } else {
            $this->ReferenceCode = $referenceCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentProccessResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
