<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProccessParameters StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentProccessParameters
 * @subpackage Structs
 */
class PaymentProccessParameters extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The BonusProgramId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BonusProgramId;
    /**
     * The ClientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReferenceCode;
    /**
     * The CreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCard
     */
    public $CreditCard;
    /**
     * The Installment
     * @var int
     */
    public $Installment;
    /**
     * The UseSafeKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseSafeKey;
    /**
     * The VirtualPosId
     * @var int
     */
    public $VirtualPosId;
    /**
     * Constructor method for PaymentProccessParameters
     * @uses PaymentProccessParameters::setAmount()
     * @uses PaymentProccessParameters::setBonusProgramId()
     * @uses PaymentProccessParameters::setClientReferenceCode()
     * @uses PaymentProccessParameters::setCreditCard()
     * @uses PaymentProccessParameters::setInstallment()
     * @uses PaymentProccessParameters::setUseSafeKey()
     * @uses PaymentProccessParameters::setVirtualPosId()
     * @param float $amount
     * @param string $bonusProgramId
     * @param string $clientReferenceCode
     * @param \StructType\CreditCard $creditCard
     * @param int $installment
     * @param bool $useSafeKey
     * @param int $virtualPosId
     */
    public function __construct($amount = null, $bonusProgramId = null, $clientReferenceCode = null, \StructType\CreditCard $creditCard = null, $installment = null, $useSafeKey = null, $virtualPosId = null)
    {
        $this
            ->setAmount($amount)
            ->setBonusProgramId($bonusProgramId)
            ->setClientReferenceCode($clientReferenceCode)
            ->setCreditCard($creditCard)
            ->setInstallment($installment)
            ->setUseSafeKey($useSafeKey)
            ->setVirtualPosId($virtualPosId);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PaymentProccessParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BonusProgramId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBonusProgramId()
    {
        return isset($this->BonusProgramId) ? $this->BonusProgramId : null;
    }
    /**
     * Set BonusProgramId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bonusProgramId
     * @return \StructType\PaymentProccessParameters
     */
    public function setBonusProgramId($bonusProgramId = null)
    {
        // validation for constraint: string
        if (!is_null($bonusProgramId) && !is_string($bonusProgramId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bonusProgramId)), __LINE__);
        }
        if (is_null($bonusProgramId) || (is_array($bonusProgramId) && empty($bonusProgramId))) {
            unset($this->BonusProgramId);
        } else {
            $this->BonusProgramId = $bonusProgramId;
        }
        return $this;
    }
    /**
     * Get ClientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->ClientReferenceCode) ? $this->ClientReferenceCode : null;
    }
    /**
     * Set ClientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\PaymentProccessParameters
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->ClientReferenceCode);
        } else {
            $this->ClientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Get CreditCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCard|null
     */
    public function getCreditCard()
    {
        return isset($this->CreditCard) ? $this->CreditCard : null;
    }
    /**
     * Set CreditCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CreditCard $creditCard
     * @return \StructType\PaymentProccessParameters
     */
    public function setCreditCard(\StructType\CreditCard $creditCard = null)
    {
        if (is_null($creditCard) || (is_array($creditCard) && empty($creditCard))) {
            unset($this->CreditCard);
        } else {
            $this->CreditCard = $creditCard;
        }
        return $this;
    }
    /**
     * Get Installment value
     * @return int|null
     */
    public function getInstallment()
    {
        return $this->Installment;
    }
    /**
     * Set Installment value
     * @param int $installment
     * @return \StructType\PaymentProccessParameters
     */
    public function setInstallment($installment = null)
    {
        // validation for constraint: int
        if (!is_null($installment) && !is_numeric($installment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($installment)), __LINE__);
        }
        $this->Installment = $installment;
        return $this;
    }
    /**
     * Get UseSafeKey value
     * @return bool|null
     */
    public function getUseSafeKey()
    {
        return $this->UseSafeKey;
    }
    /**
     * Set UseSafeKey value
     * @param bool $useSafeKey
     * @return \StructType\PaymentProccessParameters
     */
    public function setUseSafeKey($useSafeKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSafeKey) && !is_bool($useSafeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useSafeKey)), __LINE__);
        }
        $this->UseSafeKey = $useSafeKey;
        return $this;
    }
    /**
     * Get VirtualPosId value
     * @return int|null
     */
    public function getVirtualPosId()
    {
        return $this->VirtualPosId;
    }
    /**
     * Set VirtualPosId value
     * @param int $virtualPosId
     * @return \StructType\PaymentProccessParameters
     */
    public function setVirtualPosId($virtualPosId = null)
    {
        // validation for constraint: int
        if (!is_null($virtualPosId) && !is_numeric($virtualPosId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($virtualPosId)), __LINE__);
        }
        $this->VirtualPosId = $virtualPosId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentProccessParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
