<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment3DContent StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment3DContent
 * @subpackage Structs
 */
class Payment3DContent extends AbstractStructBase
{
    /**
     * The FormPostContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormPostContent;
    /**
     * The InternalMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalMessage;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The ReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceCode;
    /**
     * Constructor method for Payment3DContent
     * @uses Payment3DContent::setFormPostContent()
     * @uses Payment3DContent::setInternalMessage()
     * @uses Payment3DContent::setIsSuccess()
     * @uses Payment3DContent::setReferenceCode()
     * @param string $formPostContent
     * @param string $internalMessage
     * @param bool $isSuccess
     * @param string $referenceCode
     */
    public function __construct($formPostContent = null, $internalMessage = null, $isSuccess = null, $referenceCode = null)
    {
        $this
            ->setFormPostContent($formPostContent)
            ->setInternalMessage($internalMessage)
            ->setIsSuccess($isSuccess)
            ->setReferenceCode($referenceCode);
    }
    /**
     * Get FormPostContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormPostContent()
    {
        return isset($this->FormPostContent) ? $this->FormPostContent : null;
    }
    /**
     * Set FormPostContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formPostContent
     * @return \StructType\Payment3DContent
     */
    public function setFormPostContent($formPostContent = null)
    {
        // validation for constraint: string
        if (!is_null($formPostContent) && !is_string($formPostContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formPostContent)), __LINE__);
        }
        if (is_null($formPostContent) || (is_array($formPostContent) && empty($formPostContent))) {
            unset($this->FormPostContent);
        } else {
            $this->FormPostContent = $formPostContent;
        }
        return $this;
    }
    /**
     * Get InternalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalMessage()
    {
        return isset($this->InternalMessage) ? $this->InternalMessage : null;
    }
    /**
     * Set InternalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalMessage
     * @return \StructType\Payment3DContent
     */
    public function setInternalMessage($internalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($internalMessage) && !is_string($internalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalMessage)), __LINE__);
        }
        if (is_null($internalMessage) || (is_array($internalMessage) && empty($internalMessage))) {
            unset($this->InternalMessage);
        } else {
            $this->InternalMessage = $internalMessage;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\Payment3DContent
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get ReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceCode()
    {
        return isset($this->ReferenceCode) ? $this->ReferenceCode : null;
    }
    /**
     * Set ReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceCode
     * @return \StructType\Payment3DContent
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($referenceCode) && !is_string($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceCode)), __LINE__);
        }
        if (is_null($referenceCode) || (is_array($referenceCode) && empty($referenceCode))) {
            unset($this->ReferenceCode);
        } else {
            $this->ReferenceCode = $referenceCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment3DContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
