<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVirtualPosListWithBinInfo StructType
 * @subpackage Structs
 */
class GetVirtualPosListWithBinInfo extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The binNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $binNumber;
    /**
     * Constructor method for GetVirtualPosListWithBinInfo
     * @uses GetVirtualPosListWithBinInfo::setAuthInfo()
     * @uses GetVirtualPosListWithBinInfo::setBinNumber()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param string $binNumber
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, $binNumber = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setBinNumber($binNumber);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\GetVirtualPosListWithBinInfo
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get binNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBinNumber()
    {
        return isset($this->binNumber) ? $this->binNumber : null;
    }
    /**
     * Set binNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $binNumber
     * @return \StructType\GetVirtualPosListWithBinInfo
     */
    public function setBinNumber($binNumber = null)
    {
        // validation for constraint: string
        if (!is_null($binNumber) && !is_string($binNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($binNumber)), __LINE__);
        }
        if (is_null($binNumber) || (is_array($binNumber) && empty($binNumber))) {
            unset($this->binNumber);
        } else {
            $this->binNumber = $binNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVirtualPosListWithBinInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
