<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get3DContent StructType
 * @subpackage Structs
 */
class Get3DContent extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The paymentParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentProccessParameters
     */
    public $paymentParameters;
    /**
     * The successUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $successUrl;
    /**
     * The failUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $failUrl;
    /**
     * The formAutoPost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $formAutoPost;
    /**
     * The autoGenerateReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoGenerateReferenceCode;
    /**
     * Constructor method for Get3DContent
     * @uses Get3DContent::setAuthInfo()
     * @uses Get3DContent::setPaymentParameters()
     * @uses Get3DContent::setSuccessUrl()
     * @uses Get3DContent::setFailUrl()
     * @uses Get3DContent::setFormAutoPost()
     * @uses Get3DContent::setAutoGenerateReferenceCode()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param \StructType\PaymentProccessParameters $paymentParameters
     * @param string $successUrl
     * @param string $failUrl
     * @param bool $formAutoPost
     * @param bool $autoGenerateReferenceCode
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, \StructType\PaymentProccessParameters $paymentParameters = null, $successUrl = null, $failUrl = null, $formAutoPost = null, $autoGenerateReferenceCode = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setPaymentParameters($paymentParameters)
            ->setSuccessUrl($successUrl)
            ->setFailUrl($failUrl)
            ->setFormAutoPost($formAutoPost)
            ->setAutoGenerateReferenceCode($autoGenerateReferenceCode);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\Get3DContent
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get paymentParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentProccessParameters|null
     */
    public function getPaymentParameters()
    {
        return isset($this->paymentParameters) ? $this->paymentParameters : null;
    }
    /**
     * Set paymentParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PaymentProccessParameters $paymentParameters
     * @return \StructType\Get3DContent
     */
    public function setPaymentParameters(\StructType\PaymentProccessParameters $paymentParameters = null)
    {
        if (is_null($paymentParameters) || (is_array($paymentParameters) && empty($paymentParameters))) {
            unset($this->paymentParameters);
        } else {
            $this->paymentParameters = $paymentParameters;
        }
        return $this;
    }
    /**
     * Get successUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuccessUrl()
    {
        return isset($this->successUrl) ? $this->successUrl : null;
    }
    /**
     * Set successUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $successUrl
     * @return \StructType\Get3DContent
     */
    public function setSuccessUrl($successUrl = null)
    {
        // validation for constraint: string
        if (!is_null($successUrl) && !is_string($successUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($successUrl)), __LINE__);
        }
        if (is_null($successUrl) || (is_array($successUrl) && empty($successUrl))) {
            unset($this->successUrl);
        } else {
            $this->successUrl = $successUrl;
        }
        return $this;
    }
    /**
     * Get failUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailUrl()
    {
        return isset($this->failUrl) ? $this->failUrl : null;
    }
    /**
     * Set failUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failUrl
     * @return \StructType\Get3DContent
     */
    public function setFailUrl($failUrl = null)
    {
        // validation for constraint: string
        if (!is_null($failUrl) && !is_string($failUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failUrl)), __LINE__);
        }
        if (is_null($failUrl) || (is_array($failUrl) && empty($failUrl))) {
            unset($this->failUrl);
        } else {
            $this->failUrl = $failUrl;
        }
        return $this;
    }
    /**
     * Get formAutoPost value
     * @return bool|null
     */
    public function getFormAutoPost()
    {
        return $this->formAutoPost;
    }
    /**
     * Set formAutoPost value
     * @param bool $formAutoPost
     * @return \StructType\Get3DContent
     */
    public function setFormAutoPost($formAutoPost = null)
    {
        // validation for constraint: boolean
        if (!is_null($formAutoPost) && !is_bool($formAutoPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($formAutoPost)), __LINE__);
        }
        $this->formAutoPost = $formAutoPost;
        return $this;
    }
    /**
     * Get autoGenerateReferenceCode value
     * @return bool|null
     */
    public function getAutoGenerateReferenceCode()
    {
        return $this->autoGenerateReferenceCode;
    }
    /**
     * Set autoGenerateReferenceCode value
     * @param bool $autoGenerateReferenceCode
     * @return \StructType\Get3DContent
     */
    public function setAutoGenerateReferenceCode($autoGenerateReferenceCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoGenerateReferenceCode) && !is_bool($autoGenerateReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoGenerateReferenceCode)), __LINE__);
        }
        $this->autoGenerateReferenceCode = $autoGenerateReferenceCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Get3DContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
