<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomDynamicData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomDynamicData
 * @subpackage Structs
 */
class CustomDynamicData extends AbstractStructBase
{
    /**
     * The FormCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormCode;
    /**
     * The IntegrationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationId;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for CustomDynamicData
     * @uses CustomDynamicData::setFormCode()
     * @uses CustomDynamicData::setIntegrationId()
     * @uses CustomDynamicData::setValue()
     * @param string $formCode
     * @param string $integrationId
     * @param string $value
     */
    public function __construct($formCode = null, $integrationId = null, $value = null)
    {
        $this
            ->setFormCode($formCode)
            ->setIntegrationId($integrationId)
            ->setValue($value);
    }
    /**
     * Get FormCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormCode()
    {
        return isset($this->FormCode) ? $this->FormCode : null;
    }
    /**
     * Set FormCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formCode
     * @return \StructType\CustomDynamicData
     */
    public function setFormCode($formCode = null)
    {
        // validation for constraint: string
        if (!is_null($formCode) && !is_string($formCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formCode)), __LINE__);
        }
        if (is_null($formCode) || (is_array($formCode) && empty($formCode))) {
            unset($this->FormCode);
        } else {
            $this->FormCode = $formCode;
        }
        return $this;
    }
    /**
     * Get IntegrationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationId()
    {
        return isset($this->IntegrationId) ? $this->IntegrationId : null;
    }
    /**
     * Set IntegrationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationId
     * @return \StructType\CustomDynamicData
     */
    public function setIntegrationId($integrationId = null)
    {
        // validation for constraint: string
        if (!is_null($integrationId) && !is_string($integrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrationId)), __LINE__);
        }
        if (is_null($integrationId) || (is_array($integrationId) && empty($integrationId))) {
            unset($this->IntegrationId);
        } else {
            $this->IntegrationId = $integrationId;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\CustomDynamicData
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomDynamicData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
