<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardTokenDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardTokenDetail
 * @subpackage Structs
 */
class CreditCardTokenDetail extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The MerchantSafeKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantSafeKey;
    /**
     * The VendorVPosId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VendorVPosId;
    /**
     * Constructor method for CreditCardTokenDetail
     * @uses CreditCardTokenDetail::setErrorCode()
     * @uses CreditCardTokenDetail::setErrorMessage()
     * @uses CreditCardTokenDetail::setIsSuccess()
     * @uses CreditCardTokenDetail::setMerchantSafeKey()
     * @uses CreditCardTokenDetail::setVendorVPosId()
     * @param string $errorCode
     * @param string $errorMessage
     * @param bool $isSuccess
     * @param string $merchantSafeKey
     * @param int $vendorVPosId
     */
    public function __construct($errorCode = null, $errorMessage = null, $isSuccess = null, $merchantSafeKey = null, $vendorVPosId = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setIsSuccess($isSuccess)
            ->setMerchantSafeKey($merchantSafeKey)
            ->setVendorVPosId($vendorVPosId);
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\CreditCardTokenDetail
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\CreditCardTokenDetail
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\CreditCardTokenDetail
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get MerchantSafeKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantSafeKey()
    {
        return isset($this->MerchantSafeKey) ? $this->MerchantSafeKey : null;
    }
    /**
     * Set MerchantSafeKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantSafeKey
     * @return \StructType\CreditCardTokenDetail
     */
    public function setMerchantSafeKey($merchantSafeKey = null)
    {
        // validation for constraint: string
        if (!is_null($merchantSafeKey) && !is_string($merchantSafeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantSafeKey)), __LINE__);
        }
        if (is_null($merchantSafeKey) || (is_array($merchantSafeKey) && empty($merchantSafeKey))) {
            unset($this->MerchantSafeKey);
        } else {
            $this->MerchantSafeKey = $merchantSafeKey;
        }
        return $this;
    }
    /**
     * Get VendorVPosId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVendorVPosId()
    {
        return isset($this->VendorVPosId) ? $this->VendorVPosId : null;
    }
    /**
     * Set VendorVPosId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vendorVPosId
     * @return \StructType\CreditCardTokenDetail
     */
    public function setVendorVPosId($vendorVPosId = null)
    {
        // validation for constraint: int
        if (!is_null($vendorVPosId) && !is_numeric($vendorVPosId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendorVPosId)), __LINE__);
        }
        if (is_null($vendorVPosId) || (is_array($vendorVPosId) && empty($vendorVPosId))) {
            unset($this->VendorVPosId);
        } else {
            $this->VendorVPosId = $vendorVPosId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardTokenDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
