<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardSaveResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardSaveResult
 * @subpackage Structs
 */
class CreditCardSaveResult extends AbstractStructBase
{
    /**
     * The ExceptionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionCode;
    /**
     * The ExceptionMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionMessage;
    /**
     * The IsSuccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The SaveCreditCardDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCreditCardTokenDetail
     */
    public $SaveCreditCardDetail;
    /**
     * The TokenString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenString;
    /**
     * Constructor method for CreditCardSaveResult
     * @uses CreditCardSaveResult::setExceptionCode()
     * @uses CreditCardSaveResult::setExceptionMessage()
     * @uses CreditCardSaveResult::setIsSuccess()
     * @uses CreditCardSaveResult::setSaveCreditCardDetail()
     * @uses CreditCardSaveResult::setTokenString()
     * @param string $exceptionCode
     * @param string $exceptionMessage
     * @param bool $isSuccess
     * @param \ArrayType\ArrayOfCreditCardTokenDetail $saveCreditCardDetail
     * @param string $tokenString
     */
    public function __construct($exceptionCode = null, $exceptionMessage = null, $isSuccess = null, \ArrayType\ArrayOfCreditCardTokenDetail $saveCreditCardDetail = null, $tokenString = null)
    {
        $this
            ->setExceptionCode($exceptionCode)
            ->setExceptionMessage($exceptionMessage)
            ->setIsSuccess($isSuccess)
            ->setSaveCreditCardDetail($saveCreditCardDetail)
            ->setTokenString($tokenString);
    }
    /**
     * Get ExceptionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionCode()
    {
        return isset($this->ExceptionCode) ? $this->ExceptionCode : null;
    }
    /**
     * Set ExceptionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionCode
     * @return \StructType\CreditCardSaveResult
     */
    public function setExceptionCode($exceptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionCode) && !is_string($exceptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionCode)), __LINE__);
        }
        if (is_null($exceptionCode) || (is_array($exceptionCode) && empty($exceptionCode))) {
            unset($this->ExceptionCode);
        } else {
            $this->ExceptionCode = $exceptionCode;
        }
        return $this;
    }
    /**
     * Get ExceptionMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionMessage()
    {
        return isset($this->ExceptionMessage) ? $this->ExceptionMessage : null;
    }
    /**
     * Set ExceptionMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionMessage
     * @return \StructType\CreditCardSaveResult
     */
    public function setExceptionMessage($exceptionMessage = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionMessage) && !is_string($exceptionMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionMessage)), __LINE__);
        }
        if (is_null($exceptionMessage) || (is_array($exceptionMessage) && empty($exceptionMessage))) {
            unset($this->ExceptionMessage);
        } else {
            $this->ExceptionMessage = $exceptionMessage;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \StructType\CreditCardSaveResult
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get SaveCreditCardDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCreditCardTokenDetail|null
     */
    public function getSaveCreditCardDetail()
    {
        return isset($this->SaveCreditCardDetail) ? $this->SaveCreditCardDetail : null;
    }
    /**
     * Set SaveCreditCardDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCreditCardTokenDetail $saveCreditCardDetail
     * @return \StructType\CreditCardSaveResult
     */
    public function setSaveCreditCardDetail(\ArrayType\ArrayOfCreditCardTokenDetail $saveCreditCardDetail = null)
    {
        if (is_null($saveCreditCardDetail) || (is_array($saveCreditCardDetail) && empty($saveCreditCardDetail))) {
            unset($this->SaveCreditCardDetail);
        } else {
            $this->SaveCreditCardDetail = $saveCreditCardDetail;
        }
        return $this;
    }
    /**
     * Get TokenString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenString()
    {
        return isset($this->TokenString) ? $this->TokenString : null;
    }
    /**
     * Set TokenString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenString
     * @return \StructType\CreditCardSaveResult
     */
    public function setTokenString($tokenString = null)
    {
        // validation for constraint: string
        if (!is_null($tokenString) && !is_string($tokenString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tokenString)), __LINE__);
        }
        if (is_null($tokenString) || (is_array($tokenString) && empty($tokenString))) {
            unset($this->TokenString);
        } else {
            $this->TokenString = $tokenString;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardSaveResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
