<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCard StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCard
 * @subpackage Structs
 */
class CreditCard extends AbstractStructBase
{
    /**
     * The CardHolderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CvcNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CvcNumber;
    /**
     * The ExpMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExpMonth;
    /**
     * The ExpYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExpYear;
    /**
     * The MerchantSafeKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantSafeKey;
    /**
     * The SaveCreditCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SaveCreditCard;
    /**
     * Constructor method for CreditCard
     * @uses CreditCard::setCardHolderName()
     * @uses CreditCard::setCardNumber()
     * @uses CreditCard::setCvcNumber()
     * @uses CreditCard::setExpMonth()
     * @uses CreditCard::setExpYear()
     * @uses CreditCard::setMerchantSafeKey()
     * @uses CreditCard::setSaveCreditCard()
     * @param string $cardHolderName
     * @param string $cardNumber
     * @param string $cvcNumber
     * @param int $expMonth
     * @param int $expYear
     * @param string $merchantSafeKey
     * @param bool $saveCreditCard
     */
    public function __construct($cardHolderName = null, $cardNumber = null, $cvcNumber = null, $expMonth = null, $expYear = null, $merchantSafeKey = null, $saveCreditCard = null)
    {
        $this
            ->setCardHolderName($cardHolderName)
            ->setCardNumber($cardNumber)
            ->setCvcNumber($cvcNumber)
            ->setExpMonth($expMonth)
            ->setExpYear($expYear)
            ->setMerchantSafeKey($merchantSafeKey)
            ->setSaveCreditCard($saveCreditCard);
    }
    /**
     * Get CardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolderName()
    {
        return isset($this->CardHolderName) ? $this->CardHolderName : null;
    }
    /**
     * Set CardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolderName
     * @return \StructType\CreditCard
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderName)), __LINE__);
        }
        if (is_null($cardHolderName) || (is_array($cardHolderName) && empty($cardHolderName))) {
            unset($this->CardHolderName);
        } else {
            $this->CardHolderName = $cardHolderName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\CreditCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CvcNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCvcNumber()
    {
        return isset($this->CvcNumber) ? $this->CvcNumber : null;
    }
    /**
     * Set CvcNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cvcNumber
     * @return \StructType\CreditCard
     */
    public function setCvcNumber($cvcNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cvcNumber) && !is_string($cvcNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcNumber)), __LINE__);
        }
        if (is_null($cvcNumber) || (is_array($cvcNumber) && empty($cvcNumber))) {
            unset($this->CvcNumber);
        } else {
            $this->CvcNumber = $cvcNumber;
        }
        return $this;
    }
    /**
     * Get ExpMonth value
     * @return int|null
     */
    public function getExpMonth()
    {
        return $this->ExpMonth;
    }
    /**
     * Set ExpMonth value
     * @param int $expMonth
     * @return \StructType\CreditCard
     */
    public function setExpMonth($expMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expMonth) && !is_numeric($expMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expMonth)), __LINE__);
        }
        $this->ExpMonth = $expMonth;
        return $this;
    }
    /**
     * Get ExpYear value
     * @return int|null
     */
    public function getExpYear()
    {
        return $this->ExpYear;
    }
    /**
     * Set ExpYear value
     * @param int $expYear
     * @return \StructType\CreditCard
     */
    public function setExpYear($expYear = null)
    {
        // validation for constraint: int
        if (!is_null($expYear) && !is_numeric($expYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expYear)), __LINE__);
        }
        $this->ExpYear = $expYear;
        return $this;
    }
    /**
     * Get MerchantSafeKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantSafeKey()
    {
        return isset($this->MerchantSafeKey) ? $this->MerchantSafeKey : null;
    }
    /**
     * Set MerchantSafeKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantSafeKey
     * @return \StructType\CreditCard
     */
    public function setMerchantSafeKey($merchantSafeKey = null)
    {
        // validation for constraint: string
        if (!is_null($merchantSafeKey) && !is_string($merchantSafeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantSafeKey)), __LINE__);
        }
        if (is_null($merchantSafeKey) || (is_array($merchantSafeKey) && empty($merchantSafeKey))) {
            unset($this->MerchantSafeKey);
        } else {
            $this->MerchantSafeKey = $merchantSafeKey;
        }
        return $this;
    }
    /**
     * Get SaveCreditCard value
     * @return bool|null
     */
    public function getSaveCreditCard()
    {
        return $this->SaveCreditCard;
    }
    /**
     * Set SaveCreditCard value
     * @param bool $saveCreditCard
     * @return \StructType\CreditCard
     */
    public function setSaveCreditCard($saveCreditCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($saveCreditCard) && !is_bool($saveCreditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($saveCreditCard)), __LINE__);
        }
        $this->SaveCreditCard = $saveCreditCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
