<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitParameters StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CommitParameters
 * @subpackage Structs
 */
class CommitParameters extends AbstractStructBase
{
    /**
     * The PaymentGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentGuid;
    /**
     * Constructor method for CommitParameters
     * @uses CommitParameters::setPaymentGuid()
     * @param string $paymentGuid
     */
    public function __construct($paymentGuid = null)
    {
        $this
            ->setPaymentGuid($paymentGuid);
    }
    /**
     * Get PaymentGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentGuid()
    {
        return isset($this->PaymentGuid) ? $this->PaymentGuid : null;
    }
    /**
     * Set PaymentGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentGuid
     * @return \StructType\CommitParameters
     */
    public function setPaymentGuid($paymentGuid = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGuid) && !is_string($paymentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentGuid)), __LINE__);
        }
        if (is_null($paymentGuid) || (is_array($paymentGuid) && empty($paymentGuid))) {
            unset($this->PaymentGuid);
        } else {
            $this->PaymentGuid = $paymentGuid;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommitParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
