<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComissionRate StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ComissionRate
 * @subpackage Structs
 */
class ComissionRate extends AbstractStructBase
{
    /**
     * The BankPaymentOn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankPaymentOn;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CommRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CommRate;
    /**
     * The In
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $In;
    /**
     * The InstallmentDefferralEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentDefferralEndDate;
    /**
     * The InstallmentDefferralStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentDefferralStartDate;
    /**
     * The Instalment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Instalment;
    /**
     * The InstalmentOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstalmentOrder;
    /**
     * The IsActivePlusInstallmentDateRule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActivePlusInstallmentDateRule;
    /**
     * The MaxInstallmentLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaxInstallmentLimit;
    /**
     * The MinInstallmentLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinInstallmentLimit;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Out
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Out;
    /**
     * The PaymentDeferral
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentDeferral;
    /**
     * The PaymentDeferralLowerLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PaymentDeferralLowerLimit;
    /**
     * The PlusInstallmentEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlusInstallmentEndDate;
    /**
     * The PlusInstallmentStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlusInstallmentStartDate;
    /**
     * The PlusInstalment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlusInstalment;
    /**
     * The PlusInstalmentLowerLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PlusInstalmentLowerLimit;
    /**
     * The ServiceCommRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ServiceCommRate;
    /**
     * Constructor method for ComissionRate
     * @uses ComissionRate::setBankPaymentOn()
     * @uses ComissionRate::setCode()
     * @uses ComissionRate::setCommRate()
     * @uses ComissionRate::setIn()
     * @uses ComissionRate::setInstallmentDefferralEndDate()
     * @uses ComissionRate::setInstallmentDefferralStartDate()
     * @uses ComissionRate::setInstalment()
     * @uses ComissionRate::setInstalmentOrder()
     * @uses ComissionRate::setIsActivePlusInstallmentDateRule()
     * @uses ComissionRate::setMaxInstallmentLimit()
     * @uses ComissionRate::setMinInstallmentLimit()
     * @uses ComissionRate::setNote()
     * @uses ComissionRate::setOut()
     * @uses ComissionRate::setPaymentDeferral()
     * @uses ComissionRate::setPaymentDeferralLowerLimit()
     * @uses ComissionRate::setPlusInstallmentEndDate()
     * @uses ComissionRate::setPlusInstallmentStartDate()
     * @uses ComissionRate::setPlusInstalment()
     * @uses ComissionRate::setPlusInstalmentLowerLimit()
     * @uses ComissionRate::setServiceCommRate()
     * @param string $bankPaymentOn
     * @param string $code
     * @param float $commRate
     * @param float $in
     * @param string $installmentDefferralEndDate
     * @param string $installmentDefferralStartDate
     * @param int $instalment
     * @param int $instalmentOrder
     * @param bool $isActivePlusInstallmentDateRule
     * @param float $maxInstallmentLimit
     * @param float $minInstallmentLimit
     * @param string $note
     * @param float $out
     * @param int $paymentDeferral
     * @param float $paymentDeferralLowerLimit
     * @param string $plusInstallmentEndDate
     * @param string $plusInstallmentStartDate
     * @param int $plusInstalment
     * @param float $plusInstalmentLowerLimit
     * @param float $serviceCommRate
     */
    public function __construct($bankPaymentOn = null, $code = null, $commRate = null, $in = null, $installmentDefferralEndDate = null, $installmentDefferralStartDate = null, $instalment = null, $instalmentOrder = null, $isActivePlusInstallmentDateRule = null, $maxInstallmentLimit = null, $minInstallmentLimit = null, $note = null, $out = null, $paymentDeferral = null, $paymentDeferralLowerLimit = null, $plusInstallmentEndDate = null, $plusInstallmentStartDate = null, $plusInstalment = null, $plusInstalmentLowerLimit = null, $serviceCommRate = null)
    {
        $this
            ->setBankPaymentOn($bankPaymentOn)
            ->setCode($code)
            ->setCommRate($commRate)
            ->setIn($in)
            ->setInstallmentDefferralEndDate($installmentDefferralEndDate)
            ->setInstallmentDefferralStartDate($installmentDefferralStartDate)
            ->setInstalment($instalment)
            ->setInstalmentOrder($instalmentOrder)
            ->setIsActivePlusInstallmentDateRule($isActivePlusInstallmentDateRule)
            ->setMaxInstallmentLimit($maxInstallmentLimit)
            ->setMinInstallmentLimit($minInstallmentLimit)
            ->setNote($note)
            ->setOut($out)
            ->setPaymentDeferral($paymentDeferral)
            ->setPaymentDeferralLowerLimit($paymentDeferralLowerLimit)
            ->setPlusInstallmentEndDate($plusInstallmentEndDate)
            ->setPlusInstallmentStartDate($plusInstallmentStartDate)
            ->setPlusInstalment($plusInstalment)
            ->setPlusInstalmentLowerLimit($plusInstalmentLowerLimit)
            ->setServiceCommRate($serviceCommRate);
    }
    /**
     * Get BankPaymentOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankPaymentOn()
    {
        return isset($this->BankPaymentOn) ? $this->BankPaymentOn : null;
    }
    /**
     * Set BankPaymentOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankPaymentOn
     * @return \StructType\ComissionRate
     */
    public function setBankPaymentOn($bankPaymentOn = null)
    {
        // validation for constraint: string
        if (!is_null($bankPaymentOn) && !is_string($bankPaymentOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankPaymentOn)), __LINE__);
        }
        if (is_null($bankPaymentOn) || (is_array($bankPaymentOn) && empty($bankPaymentOn))) {
            unset($this->BankPaymentOn);
        } else {
            $this->BankPaymentOn = $bankPaymentOn;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\ComissionRate
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CommRate value
     * @return float|null
     */
    public function getCommRate()
    {
        return $this->CommRate;
    }
    /**
     * Set CommRate value
     * @param float $commRate
     * @return \StructType\ComissionRate
     */
    public function setCommRate($commRate = null)
    {
        $this->CommRate = $commRate;
        return $this;
    }
    /**
     * Get In value
     * @return float|null
     */
    public function getIn()
    {
        return $this->In;
    }
    /**
     * Set In value
     * @param float $in
     * @return \StructType\ComissionRate
     */
    public function setIn($in = null)
    {
        $this->In = $in;
        return $this;
    }
    /**
     * Get InstallmentDefferralEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentDefferralEndDate()
    {
        return isset($this->InstallmentDefferralEndDate) ? $this->InstallmentDefferralEndDate : null;
    }
    /**
     * Set InstallmentDefferralEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentDefferralEndDate
     * @return \StructType\ComissionRate
     */
    public function setInstallmentDefferralEndDate($installmentDefferralEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($installmentDefferralEndDate) && !is_string($installmentDefferralEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installmentDefferralEndDate)), __LINE__);
        }
        if (is_null($installmentDefferralEndDate) || (is_array($installmentDefferralEndDate) && empty($installmentDefferralEndDate))) {
            unset($this->InstallmentDefferralEndDate);
        } else {
            $this->InstallmentDefferralEndDate = $installmentDefferralEndDate;
        }
        return $this;
    }
    /**
     * Get InstallmentDefferralStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentDefferralStartDate()
    {
        return isset($this->InstallmentDefferralStartDate) ? $this->InstallmentDefferralStartDate : null;
    }
    /**
     * Set InstallmentDefferralStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentDefferralStartDate
     * @return \StructType\ComissionRate
     */
    public function setInstallmentDefferralStartDate($installmentDefferralStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($installmentDefferralStartDate) && !is_string($installmentDefferralStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installmentDefferralStartDate)), __LINE__);
        }
        if (is_null($installmentDefferralStartDate) || (is_array($installmentDefferralStartDate) && empty($installmentDefferralStartDate))) {
            unset($this->InstallmentDefferralStartDate);
        } else {
            $this->InstallmentDefferralStartDate = $installmentDefferralStartDate;
        }
        return $this;
    }
    /**
     * Get Instalment value
     * @return int|null
     */
    public function getInstalment()
    {
        return $this->Instalment;
    }
    /**
     * Set Instalment value
     * @param int $instalment
     * @return \StructType\ComissionRate
     */
    public function setInstalment($instalment = null)
    {
        // validation for constraint: int
        if (!is_null($instalment) && !is_numeric($instalment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($instalment)), __LINE__);
        }
        $this->Instalment = $instalment;
        return $this;
    }
    /**
     * Get InstalmentOrder value
     * @return int|null
     */
    public function getInstalmentOrder()
    {
        return $this->InstalmentOrder;
    }
    /**
     * Set InstalmentOrder value
     * @param int $instalmentOrder
     * @return \StructType\ComissionRate
     */
    public function setInstalmentOrder($instalmentOrder = null)
    {
        // validation for constraint: int
        if (!is_null($instalmentOrder) && !is_numeric($instalmentOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($instalmentOrder)), __LINE__);
        }
        $this->InstalmentOrder = $instalmentOrder;
        return $this;
    }
    /**
     * Get IsActivePlusInstallmentDateRule value
     * @return bool|null
     */
    public function getIsActivePlusInstallmentDateRule()
    {
        return $this->IsActivePlusInstallmentDateRule;
    }
    /**
     * Set IsActivePlusInstallmentDateRule value
     * @param bool $isActivePlusInstallmentDateRule
     * @return \StructType\ComissionRate
     */
    public function setIsActivePlusInstallmentDateRule($isActivePlusInstallmentDateRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActivePlusInstallmentDateRule) && !is_bool($isActivePlusInstallmentDateRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActivePlusInstallmentDateRule)), __LINE__);
        }
        $this->IsActivePlusInstallmentDateRule = $isActivePlusInstallmentDateRule;
        return $this;
    }
    /**
     * Get MaxInstallmentLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaxInstallmentLimit()
    {
        return isset($this->MaxInstallmentLimit) ? $this->MaxInstallmentLimit : null;
    }
    /**
     * Set MaxInstallmentLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maxInstallmentLimit
     * @return \StructType\ComissionRate
     */
    public function setMaxInstallmentLimit($maxInstallmentLimit = null)
    {
        if (is_null($maxInstallmentLimit) || (is_array($maxInstallmentLimit) && empty($maxInstallmentLimit))) {
            unset($this->MaxInstallmentLimit);
        } else {
            $this->MaxInstallmentLimit = $maxInstallmentLimit;
        }
        return $this;
    }
    /**
     * Get MinInstallmentLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinInstallmentLimit()
    {
        return isset($this->MinInstallmentLimit) ? $this->MinInstallmentLimit : null;
    }
    /**
     * Set MinInstallmentLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minInstallmentLimit
     * @return \StructType\ComissionRate
     */
    public function setMinInstallmentLimit($minInstallmentLimit = null)
    {
        if (is_null($minInstallmentLimit) || (is_array($minInstallmentLimit) && empty($minInstallmentLimit))) {
            unset($this->MinInstallmentLimit);
        } else {
            $this->MinInstallmentLimit = $minInstallmentLimit;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\ComissionRate
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Out value
     * @return float|null
     */
    public function getOut()
    {
        return $this->Out;
    }
    /**
     * Set Out value
     * @param float $out
     * @return \StructType\ComissionRate
     */
    public function setOut($out = null)
    {
        $this->Out = $out;
        return $this;
    }
    /**
     * Get PaymentDeferral value
     * @return int|null
     */
    public function getPaymentDeferral()
    {
        return $this->PaymentDeferral;
    }
    /**
     * Set PaymentDeferral value
     * @param int $paymentDeferral
     * @return \StructType\ComissionRate
     */
    public function setPaymentDeferral($paymentDeferral = null)
    {
        // validation for constraint: int
        if (!is_null($paymentDeferral) && !is_numeric($paymentDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentDeferral)), __LINE__);
        }
        $this->PaymentDeferral = $paymentDeferral;
        return $this;
    }
    /**
     * Get PaymentDeferralLowerLimit value
     * @return float|null
     */
    public function getPaymentDeferralLowerLimit()
    {
        return $this->PaymentDeferralLowerLimit;
    }
    /**
     * Set PaymentDeferralLowerLimit value
     * @param float $paymentDeferralLowerLimit
     * @return \StructType\ComissionRate
     */
    public function setPaymentDeferralLowerLimit($paymentDeferralLowerLimit = null)
    {
        $this->PaymentDeferralLowerLimit = $paymentDeferralLowerLimit;
        return $this;
    }
    /**
     * Get PlusInstallmentEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlusInstallmentEndDate()
    {
        return isset($this->PlusInstallmentEndDate) ? $this->PlusInstallmentEndDate : null;
    }
    /**
     * Set PlusInstallmentEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plusInstallmentEndDate
     * @return \StructType\ComissionRate
     */
    public function setPlusInstallmentEndDate($plusInstallmentEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($plusInstallmentEndDate) && !is_string($plusInstallmentEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plusInstallmentEndDate)), __LINE__);
        }
        if (is_null($plusInstallmentEndDate) || (is_array($plusInstallmentEndDate) && empty($plusInstallmentEndDate))) {
            unset($this->PlusInstallmentEndDate);
        } else {
            $this->PlusInstallmentEndDate = $plusInstallmentEndDate;
        }
        return $this;
    }
    /**
     * Get PlusInstallmentStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlusInstallmentStartDate()
    {
        return isset($this->PlusInstallmentStartDate) ? $this->PlusInstallmentStartDate : null;
    }
    /**
     * Set PlusInstallmentStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plusInstallmentStartDate
     * @return \StructType\ComissionRate
     */
    public function setPlusInstallmentStartDate($plusInstallmentStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($plusInstallmentStartDate) && !is_string($plusInstallmentStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plusInstallmentStartDate)), __LINE__);
        }
        if (is_null($plusInstallmentStartDate) || (is_array($plusInstallmentStartDate) && empty($plusInstallmentStartDate))) {
            unset($this->PlusInstallmentStartDate);
        } else {
            $this->PlusInstallmentStartDate = $plusInstallmentStartDate;
        }
        return $this;
    }
    /**
     * Get PlusInstalment value
     * @return int|null
     */
    public function getPlusInstalment()
    {
        return $this->PlusInstalment;
    }
    /**
     * Set PlusInstalment value
     * @param int $plusInstalment
     * @return \StructType\ComissionRate
     */
    public function setPlusInstalment($plusInstalment = null)
    {
        // validation for constraint: int
        if (!is_null($plusInstalment) && !is_numeric($plusInstalment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($plusInstalment)), __LINE__);
        }
        $this->PlusInstalment = $plusInstalment;
        return $this;
    }
    /**
     * Get PlusInstalmentLowerLimit value
     * @return float|null
     */
    public function getPlusInstalmentLowerLimit()
    {
        return $this->PlusInstalmentLowerLimit;
    }
    /**
     * Set PlusInstalmentLowerLimit value
     * @param float $plusInstalmentLowerLimit
     * @return \StructType\ComissionRate
     */
    public function setPlusInstalmentLowerLimit($plusInstalmentLowerLimit = null)
    {
        $this->PlusInstalmentLowerLimit = $plusInstalmentLowerLimit;
        return $this;
    }
    /**
     * Get ServiceCommRate value
     * @return float|null
     */
    public function getServiceCommRate()
    {
        return $this->ServiceCommRate;
    }
    /**
     * Set ServiceCommRate value
     * @param float $serviceCommRate
     * @return \StructType\ComissionRate
     */
    public function setServiceCommRate($serviceCommRate = null)
    {
        $this->ServiceCommRate = $serviceCommRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComissionRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
