<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardBinInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CardBinInfo
 * @subpackage Structs
 */
class CardBinInfo extends AbstractStructBase
{
    /**
     * The Bin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bin;
    /**
     * The CardOrgranizationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardOrgranizationType;
    /**
     * The CardProgram
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardProgram;
    /**
     * The CardType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Group;
    /**
     * The IsBusinessCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBusinessCard;
    /**
     * Constructor method for CardBinInfo
     * @uses CardBinInfo::setBin()
     * @uses CardBinInfo::setCardOrgranizationType()
     * @uses CardBinInfo::setCardProgram()
     * @uses CardBinInfo::setCardType()
     * @uses CardBinInfo::setGroup()
     * @uses CardBinInfo::setIsBusinessCard()
     * @param string $bin
     * @param string $cardOrgranizationType
     * @param string $cardProgram
     * @param string $cardType
     * @param string $group
     * @param bool $isBusinessCard
     */
    public function __construct($bin = null, $cardOrgranizationType = null, $cardProgram = null, $cardType = null, $group = null, $isBusinessCard = null)
    {
        $this
            ->setBin($bin)
            ->setCardOrgranizationType($cardOrgranizationType)
            ->setCardProgram($cardProgram)
            ->setCardType($cardType)
            ->setGroup($group)
            ->setIsBusinessCard($isBusinessCard);
    }
    /**
     * Get Bin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBin()
    {
        return isset($this->Bin) ? $this->Bin : null;
    }
    /**
     * Set Bin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bin
     * @return \StructType\CardBinInfo
     */
    public function setBin($bin = null)
    {
        // validation for constraint: string
        if (!is_null($bin) && !is_string($bin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bin)), __LINE__);
        }
        if (is_null($bin) || (is_array($bin) && empty($bin))) {
            unset($this->Bin);
        } else {
            $this->Bin = $bin;
        }
        return $this;
    }
    /**
     * Get CardOrgranizationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardOrgranizationType()
    {
        return isset($this->CardOrgranizationType) ? $this->CardOrgranizationType : null;
    }
    /**
     * Set CardOrgranizationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardOrgranizationType
     * @return \StructType\CardBinInfo
     */
    public function setCardOrgranizationType($cardOrgranizationType = null)
    {
        // validation for constraint: string
        if (!is_null($cardOrgranizationType) && !is_string($cardOrgranizationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardOrgranizationType)), __LINE__);
        }
        if (is_null($cardOrgranizationType) || (is_array($cardOrgranizationType) && empty($cardOrgranizationType))) {
            unset($this->CardOrgranizationType);
        } else {
            $this->CardOrgranizationType = $cardOrgranizationType;
        }
        return $this;
    }
    /**
     * Get CardProgram value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardProgram()
    {
        return isset($this->CardProgram) ? $this->CardProgram : null;
    }
    /**
     * Set CardProgram value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardProgram
     * @return \StructType\CardBinInfo
     */
    public function setCardProgram($cardProgram = null)
    {
        // validation for constraint: string
        if (!is_null($cardProgram) && !is_string($cardProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardProgram)), __LINE__);
        }
        if (is_null($cardProgram) || (is_array($cardProgram) && empty($cardProgram))) {
            unset($this->CardProgram);
        } else {
            $this->CardProgram = $cardProgram;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \StructType\CardBinInfo
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get Group value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroup()
    {
        return isset($this->Group) ? $this->Group : null;
    }
    /**
     * Set Group value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $group
     * @return \StructType\CardBinInfo
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        if (is_null($group) || (is_array($group) && empty($group))) {
            unset($this->Group);
        } else {
            $this->Group = $group;
        }
        return $this;
    }
    /**
     * Get IsBusinessCard value
     * @return bool|null
     */
    public function getIsBusinessCard()
    {
        return $this->IsBusinessCard;
    }
    /**
     * Set IsBusinessCard value
     * @param bool $isBusinessCard
     * @return \StructType\CardBinInfo
     */
    public function setIsBusinessCard($isBusinessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBusinessCard) && !is_bool($isBusinessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBusinessCard)), __LINE__);
        }
        $this->IsBusinessCard = $isBusinessCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardBinInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
