<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelByClientReferenceCode StructType
 * @subpackage Structs
 */
class CancelByClientReferenceCode extends AbstractStructBase
{
    /**
     * The authInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationInfo
     */
    public $authInfo;
    /**
     * The clientReferenceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $clientReferenceCode;
    /**
     * Constructor method for CancelByClientReferenceCode
     * @uses CancelByClientReferenceCode::setAuthInfo()
     * @uses CancelByClientReferenceCode::setClientReferenceCode()
     * @param \StructType\AuthenticationInfo $authInfo
     * @param string $clientReferenceCode
     */
    public function __construct(\StructType\AuthenticationInfo $authInfo = null, $clientReferenceCode = null)
    {
        $this
            ->setAuthInfo($authInfo)
            ->setClientReferenceCode($clientReferenceCode);
    }
    /**
     * Get authInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationInfo|null
     */
    public function getAuthInfo()
    {
        return isset($this->authInfo) ? $this->authInfo : null;
    }
    /**
     * Set authInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationInfo $authInfo
     * @return \StructType\CancelByClientReferenceCode
     */
    public function setAuthInfo(\StructType\AuthenticationInfo $authInfo = null)
    {
        if (is_null($authInfo) || (is_array($authInfo) && empty($authInfo))) {
            unset($this->authInfo);
        } else {
            $this->authInfo = $authInfo;
        }
        return $this;
    }
    /**
     * Get clientReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReferenceCode()
    {
        return isset($this->clientReferenceCode) ? $this->clientReferenceCode : null;
    }
    /**
     * Set clientReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReferenceCode
     * @return \StructType\CancelByClientReferenceCode
     */
    public function setClientReferenceCode($clientReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceCode) && !is_string($clientReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceCode)), __LINE__);
        }
        if (is_null($clientReferenceCode) || (is_array($clientReferenceCode) && empty($clientReferenceCode))) {
            unset($this->clientReferenceCode);
        } else {
            $this->clientReferenceCode = $clientReferenceCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelByClientReferenceCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
