<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignProcessParameters StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignProcessParameters
 * @subpackage Structs
 */
class CampaignProcessParameters extends AbstractStructBase
{
    /**
     * The CreditCardNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The VPosId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VPosId;
    /**
     * Constructor method for CampaignProcessParameters
     * @uses CampaignProcessParameters::setCreditCardNumber()
     * @uses CampaignProcessParameters::setVPosId()
     * @param string $creditCardNumber
     * @param int $vPosId
     */
    public function __construct($creditCardNumber = null, $vPosId = null)
    {
        $this
            ->setCreditCardNumber($creditCardNumber)
            ->setVPosId($vPosId);
    }
    /**
     * Get CreditCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return isset($this->CreditCardNumber) ? $this->CreditCardNumber : null;
    }
    /**
     * Set CreditCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardNumber
     * @return \StructType\CampaignProcessParameters
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumber)), __LINE__);
        }
        if (is_null($creditCardNumber) || (is_array($creditCardNumber) && empty($creditCardNumber))) {
            unset($this->CreditCardNumber);
        } else {
            $this->CreditCardNumber = $creditCardNumber;
        }
        return $this;
    }
    /**
     * Get VPosId value
     * @return int|null
     */
    public function getVPosId()
    {
        return $this->VPosId;
    }
    /**
     * Set VPosId value
     * @param int $vPosId
     * @return \StructType\CampaignProcessParameters
     */
    public function setVPosId($vPosId = null)
    {
        // validation for constraint: int
        if (!is_null($vPosId) && !is_numeric($vPosId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vPosId)), __LINE__);
        }
        $this->VPosId = $vPosId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignProcessParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
