<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendFailed3DResultPro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendFailed3DResultPro $parameters
     * @return \StructType\SendFailed3DResultProResponse|bool
     */
    public function SendFailed3DResultPro(\StructType\SendFailed3DResultPro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendFailed3DResultPro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendApproved3DResultPro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendApproved3DResultPro $parameters
     * @return \StructType\SendApproved3DResultProResponse|bool
     */
    public function SendApproved3DResultPro(\StructType\SendApproved3DResultPro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendApproved3DResultPro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendFailed3DResult
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendFailed3DResult $parameters
     * @return \StructType\SendFailed3DResultResponse|bool
     */
    public function SendFailed3DResult(\StructType\SendFailed3DResult $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendFailed3DResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendApproved3DResult
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendApproved3DResult $parameters
     * @return \StructType\SendApproved3DResultResponse|bool
     */
    public function SendApproved3DResult(\StructType\SendApproved3DResult $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendApproved3DResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendApproved3DResultProResponse|\StructType\SendApproved3DResultResponse|\StructType\SendFailed3DResultProResponse|\StructType\SendFailed3DResultResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
