<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sale ServiceType
 * @subpackage Services
 */
class Sale extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaleDefaultPos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaleDefaultPos $parameters
     * @return \StructType\SaleDefaultPosResponse|bool
     */
    public function SaleDefaultPos(\StructType\SaleDefaultPos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaleDefaultPos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Sale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sale $parameters
     * @return \StructType\SaleResponse|bool
     */
    public function Sale(\StructType\Sale $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Sale($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaleDefaultPosResponse|\StructType\SaleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
