<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCampaignList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCampaignList $parameters
     * @return \StructType\GetCampaignListResponse|bool
     */
    public function GetCampaignList(\StructType\GetCampaignList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCampaignList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTransactionByOrderReferenceForStatusInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransactionByOrderReferenceForStatusInquiry $parameters
     * @return \StructType\GetTransactionByOrderReferenceForStatusInquiryResponse|bool
     */
    public function GetTransactionByOrderReferenceForStatusInquiry(\StructType\GetTransactionByOrderReferenceForStatusInquiry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransactionByOrderReferenceForStatusInquiry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionByOrderReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransactionByOrderReference $parameters
     * @return \StructType\GetTransactionByOrderReferenceResponse|bool
     */
    public function GetTransactionByOrderReference(\StructType\GetTransactionByOrderReference $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransactionByOrderReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetTransactionByClientOrderReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransactionByClientOrderReference $parameters
     * @return \StructType\GetTransactionByClientOrderReferenceResponse|bool
     */
    public function GetTransactionByClientOrderReference(\StructType\GetTransactionByClientOrderReference $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransactionByClientOrderReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVirtualPosList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVirtualPosList $parameters
     * @return \StructType\GetVirtualPosListResponse|bool
     */
    public function GetVirtualPosList(\StructType\GetVirtualPosList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVirtualPosList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVirtualPosListBinNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVirtualPosListBinNumber $parameters
     * @return \StructType\GetVirtualPosListBinNumberResponse|bool
     */
    public function GetVirtualPosListBinNumber(\StructType\GetVirtualPosListBinNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVirtualPosListBinNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVirtualPosListWithBinInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVirtualPosListWithBinInfo $parameters
     * @return \StructType\GetVirtualPosListWithBinInfoResponse|bool
     */
    public function GetVirtualPosListWithBinInfo(\StructType\GetVirtualPosListWithBinInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVirtualPosListWithBinInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get3DContentDefaultPos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get3DContentDefaultPos $parameters
     * @return \StructType\Get3DContentDefaultPosResponse|bool
     */
    public function Get3DContentDefaultPos(\StructType\Get3DContentDefaultPos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Get3DContentDefaultPos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get3DContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get3DContent $parameters
     * @return \StructType\Get3DContentResponse|bool
     */
    public function Get3DContent(\StructType\Get3DContent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Get3DContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get3DContentDefaultPosResponse|\StructType\Get3DContentResponse|\StructType\GetCampaignListResponse|\StructType\GetTransactionByClientOrderReferenceResponse|\StructType\GetTransactionByOrderReferenceForStatusInquiryResponse|\StructType\GetTransactionByOrderReferenceResponse|\StructType\GetVirtualPosListBinNumberResponse|\StructType\GetVirtualPosListResponse|\StructType\GetVirtualPosListWithBinInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
