<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelByReferenceCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelByReferenceCode $parameters
     * @return \StructType\CancelByReferenceCodeResponse|bool
     */
    public function CancelByReferenceCode(\StructType\CancelByReferenceCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelByReferenceCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelByClientReferenceCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelByClientReferenceCode $parameters
     * @return \StructType\CancelByClientReferenceCodeResponse|bool
     */
    public function CancelByClientReferenceCode(\StructType\CancelByClientReferenceCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelByClientReferenceCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelByClientReferenceCodeResponse|\StructType\CancelByReferenceCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
