<?php

namespace EnumType;

/**
 * This class stands for ResultType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultType
 * @subpackage Enumerations
 */
class ResultType
{
    /**
     * Constant for value 'MerchantSafeError'
     * @return string 'MerchantSafeError'
     */
    const VALUE_MERCHANT_SAFE_ERROR = 'MerchantSafeError';
    /**
     * Constant for value 'SaleError'
     * @return string 'SaleError'
     */
    const VALUE_SALE_ERROR = 'SaleError';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MERCHANT_SAFE_ERROR
     * @uses self::VALUE_SALE_ERROR
     * @uses self::VALUE_SUCCESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MERCHANT_SAFE_ERROR,
            self::VALUE_SALE_ERROR,
            self::VALUE_SUCCESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
