<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVirtualPos ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfVirtualPos
 * @subpackage Arrays
 */
class ArrayOfVirtualPos extends AbstractStructArrayBase
{
    /**
     * The VirtualPos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VirtualPos[]
     */
    public $VirtualPos;
    /**
     * Constructor method for ArrayOfVirtualPos
     * @uses ArrayOfVirtualPos::setVirtualPos()
     * @param \StructType\VirtualPos[] $virtualPos
     */
    public function __construct(array $virtualPos = array())
    {
        $this
            ->setVirtualPos($virtualPos);
    }
    /**
     * Get VirtualPos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VirtualPos[]|null
     */
    public function getVirtualPos()
    {
        return isset($this->VirtualPos) ? $this->VirtualPos : null;
    }
    /**
     * Set VirtualPos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VirtualPos[] $virtualPos
     * @return \ArrayType\ArrayOfVirtualPos
     */
    public function setVirtualPos(array $virtualPos = array())
    {
        foreach ($virtualPos as $arrayOfVirtualPosVirtualPosItem) {
            // validation for constraint: itemType
            if (!$arrayOfVirtualPosVirtualPosItem instanceof \StructType\VirtualPos) {
                throw new \InvalidArgumentException(sprintf('The VirtualPos property can only contain items of \StructType\VirtualPos, "%s" given', is_object($arrayOfVirtualPosVirtualPosItem) ? get_class($arrayOfVirtualPosVirtualPosItem) : gettype($arrayOfVirtualPosVirtualPosItem)), __LINE__);
            }
        }
        if (is_null($virtualPos) || (is_array($virtualPos) && empty($virtualPos))) {
            unset($this->VirtualPos);
        } else {
            $this->VirtualPos = $virtualPos;
        }
        return $this;
    }
    /**
     * Add item to VirtualPos value
     * @throws \InvalidArgumentException
     * @param \StructType\VirtualPos $item
     * @return \ArrayType\ArrayOfVirtualPos
     */
    public function addToVirtualPos(\StructType\VirtualPos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VirtualPos) {
            throw new \InvalidArgumentException(sprintf('The VirtualPos property can only contain items of \StructType\VirtualPos, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VirtualPos[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VirtualPos|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VirtualPos|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VirtualPos|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VirtualPos|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VirtualPos|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VirtualPos
     */
    public function getAttributeName()
    {
        return 'VirtualPos';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVirtualPos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
