<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomDynamicData ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomDynamicData
 * @subpackage Arrays
 */
class ArrayOfCustomDynamicData extends AbstractStructArrayBase
{
    /**
     * The CustomDynamicData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomDynamicData[]
     */
    public $CustomDynamicData;
    /**
     * Constructor method for ArrayOfCustomDynamicData
     * @uses ArrayOfCustomDynamicData::setCustomDynamicData()
     * @param \StructType\CustomDynamicData[] $customDynamicData
     */
    public function __construct(array $customDynamicData = array())
    {
        $this
            ->setCustomDynamicData($customDynamicData);
    }
    /**
     * Get CustomDynamicData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomDynamicData[]|null
     */
    public function getCustomDynamicData()
    {
        return isset($this->CustomDynamicData) ? $this->CustomDynamicData : null;
    }
    /**
     * Set CustomDynamicData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomDynamicData[] $customDynamicData
     * @return \ArrayType\ArrayOfCustomDynamicData
     */
    public function setCustomDynamicData(array $customDynamicData = array())
    {
        foreach ($customDynamicData as $arrayOfCustomDynamicDataCustomDynamicDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomDynamicDataCustomDynamicDataItem instanceof \StructType\CustomDynamicData) {
                throw new \InvalidArgumentException(sprintf('The CustomDynamicData property can only contain items of \StructType\CustomDynamicData, "%s" given', is_object($arrayOfCustomDynamicDataCustomDynamicDataItem) ? get_class($arrayOfCustomDynamicDataCustomDynamicDataItem) : gettype($arrayOfCustomDynamicDataCustomDynamicDataItem)), __LINE__);
            }
        }
        if (is_null($customDynamicData) || (is_array($customDynamicData) && empty($customDynamicData))) {
            unset($this->CustomDynamicData);
        } else {
            $this->CustomDynamicData = $customDynamicData;
        }
        return $this;
    }
    /**
     * Add item to CustomDynamicData value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomDynamicData $item
     * @return \ArrayType\ArrayOfCustomDynamicData
     */
    public function addToCustomDynamicData(\StructType\CustomDynamicData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomDynamicData) {
            throw new \InvalidArgumentException(sprintf('The CustomDynamicData property can only contain items of \StructType\CustomDynamicData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomDynamicData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomDynamicData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomDynamicData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomDynamicData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomDynamicData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomDynamicData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomDynamicData
     */
    public function getAttributeName()
    {
        return 'CustomDynamicData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomDynamicData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
