<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCreditCardTokenDetail ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCreditCardTokenDetail
 * @subpackage Arrays
 */
class ArrayOfCreditCardTokenDetail extends AbstractStructArrayBase
{
    /**
     * The CreditCardTokenDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreditCardTokenDetail[]
     */
    public $CreditCardTokenDetail;
    /**
     * Constructor method for ArrayOfCreditCardTokenDetail
     * @uses ArrayOfCreditCardTokenDetail::setCreditCardTokenDetail()
     * @param \StructType\CreditCardTokenDetail[] $creditCardTokenDetail
     */
    public function __construct(array $creditCardTokenDetail = array())
    {
        $this
            ->setCreditCardTokenDetail($creditCardTokenDetail);
    }
    /**
     * Get CreditCardTokenDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreditCardTokenDetail[]|null
     */
    public function getCreditCardTokenDetail()
    {
        return isset($this->CreditCardTokenDetail) ? $this->CreditCardTokenDetail : null;
    }
    /**
     * Set CreditCardTokenDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CreditCardTokenDetail[] $creditCardTokenDetail
     * @return \ArrayType\ArrayOfCreditCardTokenDetail
     */
    public function setCreditCardTokenDetail(array $creditCardTokenDetail = array())
    {
        foreach ($creditCardTokenDetail as $arrayOfCreditCardTokenDetailCreditCardTokenDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfCreditCardTokenDetailCreditCardTokenDetailItem instanceof \StructType\CreditCardTokenDetail) {
                throw new \InvalidArgumentException(sprintf('The CreditCardTokenDetail property can only contain items of \StructType\CreditCardTokenDetail, "%s" given', is_object($arrayOfCreditCardTokenDetailCreditCardTokenDetailItem) ? get_class($arrayOfCreditCardTokenDetailCreditCardTokenDetailItem) : gettype($arrayOfCreditCardTokenDetailCreditCardTokenDetailItem)), __LINE__);
            }
        }
        if (is_null($creditCardTokenDetail) || (is_array($creditCardTokenDetail) && empty($creditCardTokenDetail))) {
            unset($this->CreditCardTokenDetail);
        } else {
            $this->CreditCardTokenDetail = $creditCardTokenDetail;
        }
        return $this;
    }
    /**
     * Add item to CreditCardTokenDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CreditCardTokenDetail $item
     * @return \ArrayType\ArrayOfCreditCardTokenDetail
     */
    public function addToCreditCardTokenDetail(\StructType\CreditCardTokenDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreditCardTokenDetail) {
            throw new \InvalidArgumentException(sprintf('The CreditCardTokenDetail property can only contain items of \StructType\CreditCardTokenDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreditCardTokenDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CreditCardTokenDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CreditCardTokenDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CreditCardTokenDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CreditCardTokenDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CreditCardTokenDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CreditCardTokenDetail
     */
    public function getAttributeName()
    {
        return 'CreditCardTokenDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCreditCardTokenDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
