<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfComissionRate ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfComissionRate
 * @subpackage Arrays
 */
class ArrayOfComissionRate extends AbstractStructArrayBase
{
    /**
     * The ComissionRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ComissionRate[]
     */
    public $ComissionRate;
    /**
     * Constructor method for ArrayOfComissionRate
     * @uses ArrayOfComissionRate::setComissionRate()
     * @param \StructType\ComissionRate[] $comissionRate
     */
    public function __construct(array $comissionRate = array())
    {
        $this
            ->setComissionRate($comissionRate);
    }
    /**
     * Get ComissionRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ComissionRate[]|null
     */
    public function getComissionRate()
    {
        return isset($this->ComissionRate) ? $this->ComissionRate : null;
    }
    /**
     * Set ComissionRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ComissionRate[] $comissionRate
     * @return \ArrayType\ArrayOfComissionRate
     */
    public function setComissionRate(array $comissionRate = array())
    {
        foreach ($comissionRate as $arrayOfComissionRateComissionRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfComissionRateComissionRateItem instanceof \StructType\ComissionRate) {
                throw new \InvalidArgumentException(sprintf('The ComissionRate property can only contain items of \StructType\ComissionRate, "%s" given', is_object($arrayOfComissionRateComissionRateItem) ? get_class($arrayOfComissionRateComissionRateItem) : gettype($arrayOfComissionRateComissionRateItem)), __LINE__);
            }
        }
        if (is_null($comissionRate) || (is_array($comissionRate) && empty($comissionRate))) {
            unset($this->ComissionRate);
        } else {
            $this->ComissionRate = $comissionRate;
        }
        return $this;
    }
    /**
     * Add item to ComissionRate value
     * @throws \InvalidArgumentException
     * @param \StructType\ComissionRate $item
     * @return \ArrayType\ArrayOfComissionRate
     */
    public function addToComissionRate(\StructType\ComissionRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ComissionRate) {
            throw new \InvalidArgumentException(sprintf('The ComissionRate property can only contain items of \StructType\ComissionRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ComissionRate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ComissionRate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ComissionRate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ComissionRate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ComissionRate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ComissionRate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ComissionRate
     */
    public function getAttributeName()
    {
        return 'ComissionRate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfComissionRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
