<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBonusItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBonusItem
 * @subpackage Arrays
 */
class ArrayOfBonusItem extends AbstractStructArrayBase
{
    /**
     * The BonusItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BonusItem[]
     */
    public $BonusItem;
    /**
     * Constructor method for ArrayOfBonusItem
     * @uses ArrayOfBonusItem::setBonusItem()
     * @param \StructType\BonusItem[] $bonusItem
     */
    public function __construct(array $bonusItem = array())
    {
        $this
            ->setBonusItem($bonusItem);
    }
    /**
     * Get BonusItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BonusItem[]|null
     */
    public function getBonusItem()
    {
        return isset($this->BonusItem) ? $this->BonusItem : null;
    }
    /**
     * Set BonusItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BonusItem[] $bonusItem
     * @return \ArrayType\ArrayOfBonusItem
     */
    public function setBonusItem(array $bonusItem = array())
    {
        foreach ($bonusItem as $arrayOfBonusItemBonusItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfBonusItemBonusItemItem instanceof \StructType\BonusItem) {
                throw new \InvalidArgumentException(sprintf('The BonusItem property can only contain items of \StructType\BonusItem, "%s" given', is_object($arrayOfBonusItemBonusItemItem) ? get_class($arrayOfBonusItemBonusItemItem) : gettype($arrayOfBonusItemBonusItemItem)), __LINE__);
            }
        }
        if (is_null($bonusItem) || (is_array($bonusItem) && empty($bonusItem))) {
            unset($this->BonusItem);
        } else {
            $this->BonusItem = $bonusItem;
        }
        return $this;
    }
    /**
     * Add item to BonusItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BonusItem $item
     * @return \ArrayType\ArrayOfBonusItem
     */
    public function addToBonusItem(\StructType\BonusItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BonusItem) {
            throw new \InvalidArgumentException(sprintf('The BonusItem property can only contain items of \StructType\BonusItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BonusItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BonusItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BonusItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BonusItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BonusItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BonusItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BonusItem
     */
    public function getAttributeName()
    {
        return 'BonusItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBonusItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
