<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageReference StructType
 * @subpackage Structs
 */
class MessageReference extends AbstractStructBase
{
    /**
     * The messageReferenceType
     * @var string
     */
    public $messageReferenceType;
    /**
     * The messageReferenceInfo
     * @var mixed
     */
    public $messageReferenceInfo;
    /**
     * Constructor method for MessageReference
     * @uses MessageReference::setMessageReferenceType()
     * @uses MessageReference::setMessageReferenceInfo()
     * @param string $messageReferenceType
     * @param mixed $messageReferenceInfo
     */
    public function __construct($messageReferenceType = null, $messageReferenceInfo = null)
    {
        $this
            ->setMessageReferenceType($messageReferenceType)
            ->setMessageReferenceInfo($messageReferenceInfo);
    }
    /**
     * Get messageReferenceType value
     * @return string|null
     */
    public function getMessageReferenceType()
    {
        return $this->messageReferenceType;
    }
    /**
     * Set messageReferenceType value
     * @param string $messageReferenceType
     * @return \StructType\MessageReference
     */
    public function setMessageReferenceType($messageReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($messageReferenceType) && !is_string($messageReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReferenceType)), __LINE__);
        }
        $this->messageReferenceType = $messageReferenceType;
        return $this;
    }
    /**
     * Get messageReferenceInfo value
     * @return mixed|null
     */
    public function getMessageReferenceInfo()
    {
        return $this->messageReferenceInfo;
    }
    /**
     * Set messageReferenceInfo value
     * @param mixed $messageReferenceInfo
     * @return \StructType\MessageReference
     */
    public function setMessageReferenceInfo($messageReferenceInfo = null)
    {
        $this->messageReferenceInfo = $messageReferenceInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
