<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogicalExpressionType StructType
 * @subpackage Structs
 */
class LogicalExpressionType extends AbstractStructBase
{
    /**
     * The logicalOperator
     * @var string
     */
    public $logicalOperator;
    /**
     * The LogicalExpression
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LogicalExpressionType[]
     */
    public $LogicalExpression;
    /**
     * The ComparisonExpression
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ComparisonExpressionType[]
     */
    public $ComparisonExpression;
    /**
     * Constructor method for LogicalExpressionType
     * @uses LogicalExpressionType::setLogicalOperator()
     * @uses LogicalExpressionType::setLogicalExpression()
     * @uses LogicalExpressionType::setComparisonExpression()
     * @param string $logicalOperator
     * @param \StructType\LogicalExpressionType[] $logicalExpression
     * @param \StructType\ComparisonExpressionType[] $comparisonExpression
     */
    public function __construct($logicalOperator = null, array $logicalExpression = array(), array $comparisonExpression = array())
    {
        $this
            ->setLogicalOperator($logicalOperator)
            ->setLogicalExpression($logicalExpression)
            ->setComparisonExpression($comparisonExpression);
    }
    /**
     * Get logicalOperator value
     * @return string|null
     */
    public function getLogicalOperator()
    {
        return $this->logicalOperator;
    }
    /**
     * Set logicalOperator value
     * @uses \EnumType\LogicalOperator::valueIsValid()
     * @uses \EnumType\LogicalOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalOperator
     * @return \StructType\LogicalExpressionType
     */
    public function setLogicalOperator($logicalOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LogicalOperator::valueIsValid($logicalOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalOperator, implode(', ', \EnumType\LogicalOperator::getValidValues())), __LINE__);
        }
        $this->logicalOperator = $logicalOperator;
        return $this;
    }
    /**
     * Get LogicalExpression value
     * @return \StructType\LogicalExpressionType[]|null
     */
    public function getLogicalExpression()
    {
        return $this->LogicalExpression;
    }
    /**
     * Set LogicalExpression value
     * @throws \InvalidArgumentException
     * @param \StructType\LogicalExpressionType[] $logicalExpression
     * @return \StructType\LogicalExpressionType
     */
    public function setLogicalExpression(array $logicalExpression = array())
    {
        foreach ($logicalExpression as $logicalExpressionTypeLogicalExpressionItem) {
            // validation for constraint: itemType
            if (!$logicalExpressionTypeLogicalExpressionItem instanceof \StructType\LogicalExpressionType) {
                throw new \InvalidArgumentException(sprintf('The LogicalExpression property can only contain items of \StructType\LogicalExpressionType, "%s" given', is_object($logicalExpressionTypeLogicalExpressionItem) ? get_class($logicalExpressionTypeLogicalExpressionItem) : gettype($logicalExpressionTypeLogicalExpressionItem)), __LINE__);
            }
        }
        $this->LogicalExpression = $logicalExpression;
        return $this;
    }
    /**
     * Add item to LogicalExpression value
     * @throws \InvalidArgumentException
     * @param \StructType\LogicalExpressionType $item
     * @return \StructType\LogicalExpressionType
     */
    public function addToLogicalExpression(\StructType\LogicalExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LogicalExpressionType) {
            throw new \InvalidArgumentException(sprintf('The LogicalExpression property can only contain items of \StructType\LogicalExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LogicalExpression[] = $item;
        return $this;
    }
    /**
     * Get ComparisonExpression value
     * @return \StructType\ComparisonExpressionType[]|null
     */
    public function getComparisonExpression()
    {
        return $this->ComparisonExpression;
    }
    /**
     * Set ComparisonExpression value
     * @throws \InvalidArgumentException
     * @param \StructType\ComparisonExpressionType[] $comparisonExpression
     * @return \StructType\LogicalExpressionType
     */
    public function setComparisonExpression(array $comparisonExpression = array())
    {
        foreach ($comparisonExpression as $logicalExpressionTypeComparisonExpressionItem) {
            // validation for constraint: itemType
            if (!$logicalExpressionTypeComparisonExpressionItem instanceof \StructType\ComparisonExpressionType) {
                throw new \InvalidArgumentException(sprintf('The ComparisonExpression property can only contain items of \StructType\ComparisonExpressionType, "%s" given', is_object($logicalExpressionTypeComparisonExpressionItem) ? get_class($logicalExpressionTypeComparisonExpressionItem) : gettype($logicalExpressionTypeComparisonExpressionItem)), __LINE__);
            }
        }
        $this->ComparisonExpression = $comparisonExpression;
        return $this;
    }
    /**
     * Add item to ComparisonExpression value
     * @throws \InvalidArgumentException
     * @param \StructType\ComparisonExpressionType $item
     * @return \StructType\LogicalExpressionType
     */
    public function addToComparisonExpression(\StructType\ComparisonExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ComparisonExpressionType) {
            throw new \InvalidArgumentException(sprintf('The ComparisonExpression property can only contain items of \StructType\ComparisonExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ComparisonExpression[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LogicalExpressionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
