<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inventory StructType
 * @subpackage Structs
 */
class Inventory extends AbstractStructBase
{
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Warehouse;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Item;
    /**
     * The WarehouseDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseDescription;
    /**
     * The ItemDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Unit;
    /**
     * The OnHand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OnHand;
    /**
     * Constructor method for Inventory
     * @uses Inventory::setWarehouse()
     * @uses Inventory::setItem()
     * @uses Inventory::setWarehouseDescription()
     * @uses Inventory::setItemDescription()
     * @uses Inventory::setUnit()
     * @uses Inventory::setOnHand()
     * @param string $warehouse
     * @param string $item
     * @param string $warehouseDescription
     * @param string $itemDescription
     * @param string $unit
     * @param float $onHand
     */
    public function __construct($warehouse = null, $item = null, $warehouseDescription = null, $itemDescription = null, $unit = null, $onHand = null)
    {
        $this
            ->setWarehouse($warehouse)
            ->setItem($item)
            ->setWarehouseDescription($warehouseDescription)
            ->setItemDescription($itemDescription)
            ->setUnit($unit)
            ->setOnHand($onHand);
    }
    /**
     * Get Warehouse value
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param string $warehouse
     * @return \StructType\Inventory
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouse)), __LINE__);
        }
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param string $item
     * @return \StructType\Inventory
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($item)), __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Get WarehouseDescription value
     * @return string|null
     */
    public function getWarehouseDescription()
    {
        return $this->WarehouseDescription;
    }
    /**
     * Set WarehouseDescription value
     * @param string $warehouseDescription
     * @return \StructType\Inventory
     */
    public function setWarehouseDescription($warehouseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseDescription) && !is_string($warehouseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseDescription)), __LINE__);
        }
        $this->WarehouseDescription = $warehouseDescription;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \StructType\Inventory
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \StructType\Inventory
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get OnHand value
     * @return float|null
     */
    public function getOnHand()
    {
        return $this->OnHand;
    }
    /**
     * Set OnHand value
     * @param float $onHand
     * @return \StructType\Inventory
     */
    public function setOnHand($onHand = null)
    {
        $this->OnHand = $onHand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
