<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationArea StructType
 * @subpackage Structs
 */
class InformationArea extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\InformationMessage[]
     */
    public $Message;
    /**
     * Constructor method for InformationArea
     * @uses InformationArea::setMessage()
     * @param \StructType\InformationMessage[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * @return \StructType\InformationMessage[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \StructType\InformationMessage[] $message
     * @return \StructType\InformationArea
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $informationAreaMessageItem) {
            // validation for constraint: itemType
            if (!$informationAreaMessageItem instanceof \StructType\InformationMessage) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\InformationMessage, "%s" given', is_object($informationAreaMessageItem) ? get_class($informationAreaMessageItem) : gettype($informationAreaMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \StructType\InformationMessage $item
     * @return \StructType\InformationArea
     */
    public function addToMessage(\StructType\InformationMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InformationMessage) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\InformationMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformationArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
