<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ControlArea StructType
 * @subpackage Structs
 */
class ControlArea extends AbstractStructBase
{
    /**
     * The Selection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectionType
     */
    public $Selection;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FilterType
     */
    public $Filter;
    /**
     * The sortingExpression
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sortingExpression;
    /**
     * The languageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $languageID;
    /**
     * The suppressDefaultLanguageBehavior
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $suppressDefaultLanguageBehavior;
    /**
     * The createRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $createRef;
    /**
     * The referenceID
     * @var string
     */
    public $referenceID;
    /**
     * Constructor method for ControlArea
     * @uses ControlArea::setSelection()
     * @uses ControlArea::setFilter()
     * @uses ControlArea::setSortingExpression()
     * @uses ControlArea::setLanguageID()
     * @uses ControlArea::setSuppressDefaultLanguageBehavior()
     * @uses ControlArea::setCreateRef()
     * @uses ControlArea::setReferenceID()
     * @param \StructType\SelectionType $selection
     * @param \StructType\FilterType $filter
     * @param string $sortingExpression
     * @param string[] $languageID
     * @param bool $suppressDefaultLanguageBehavior
     * @param bool $createRef
     * @param string $referenceID
     */
    public function __construct(\StructType\SelectionType $selection = null, \StructType\FilterType $filter = null, $sortingExpression = null, array $languageID = array(), $suppressDefaultLanguageBehavior = null, $createRef = null, $referenceID = null)
    {
        $this
            ->setSelection($selection)
            ->setFilter($filter)
            ->setSortingExpression($sortingExpression)
            ->setLanguageID($languageID)
            ->setSuppressDefaultLanguageBehavior($suppressDefaultLanguageBehavior)
            ->setCreateRef($createRef)
            ->setReferenceID($referenceID);
    }
    /**
     * Get Selection value
     * @return \StructType\SelectionType|null
     */
    public function getSelection()
    {
        return $this->Selection;
    }
    /**
     * Set Selection value
     * @param \StructType\SelectionType $selection
     * @return \StructType\ControlArea
     */
    public function setSelection(\StructType\SelectionType $selection = null)
    {
        $this->Selection = $selection;
        return $this;
    }
    /**
     * Get Filter value
     * @return \StructType\FilterType|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param \StructType\FilterType $filter
     * @return \StructType\ControlArea
     */
    public function setFilter(\StructType\FilterType $filter = null)
    {
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get sortingExpression value
     * @return string|null
     */
    public function getSortingExpression()
    {
        return $this->sortingExpression;
    }
    /**
     * Set sortingExpression value
     * @param string $sortingExpression
     * @return \StructType\ControlArea
     */
    public function setSortingExpression($sortingExpression = null)
    {
        // validation for constraint: string
        if (!is_null($sortingExpression) && !is_string($sortingExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortingExpression)), __LINE__);
        }
        $this->sortingExpression = $sortingExpression;
        return $this;
    }
    /**
     * Get languageID value
     * @return string[]|null
     */
    public function getLanguageID()
    {
        return $this->languageID;
    }
    /**
     * Set languageID value
     * @throws \InvalidArgumentException
     * @param string[] $languageID
     * @return \StructType\ControlArea
     */
    public function setLanguageID(array $languageID = array())
    {
        foreach ($languageID as $controlAreaLanguageIDItem) {
            // validation for constraint: itemType
            if (!is_string($controlAreaLanguageIDItem)) {
                throw new \InvalidArgumentException(sprintf('The languageID property can only contain items of language, "%s" given', is_object($controlAreaLanguageIDItem) ? get_class($controlAreaLanguageIDItem) : gettype($controlAreaLanguageIDItem)), __LINE__);
            }
        }
        $this->languageID = $languageID;
        return $this;
    }
    /**
     * Add item to languageID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ControlArea
     */
    public function addToLanguageID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The languageID property can only contain items of language, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->languageID[] = $item;
        return $this;
    }
    /**
     * Get suppressDefaultLanguageBehavior value
     * @return bool|null
     */
    public function getSuppressDefaultLanguageBehavior()
    {
        return $this->suppressDefaultLanguageBehavior;
    }
    /**
     * Set suppressDefaultLanguageBehavior value
     * @param bool $suppressDefaultLanguageBehavior
     * @return \StructType\ControlArea
     */
    public function setSuppressDefaultLanguageBehavior($suppressDefaultLanguageBehavior = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressDefaultLanguageBehavior) && !is_bool($suppressDefaultLanguageBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppressDefaultLanguageBehavior)), __LINE__);
        }
        $this->suppressDefaultLanguageBehavior = $suppressDefaultLanguageBehavior;
        return $this;
    }
    /**
     * Get createRef value
     * @return bool|null
     */
    public function getCreateRef()
    {
        return $this->createRef;
    }
    /**
     * Set createRef value
     * @param bool $createRef
     * @return \StructType\ControlArea
     */
    public function setCreateRef($createRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($createRef) && !is_bool($createRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createRef)), __LINE__);
        }
        $this->createRef = $createRef;
        return $this;
    }
    /**
     * Get referenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->referenceID;
    }
    /**
     * Set referenceID value
     * @param string $referenceID
     * @return \StructType\ControlArea
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceID)), __LINE__);
        }
        $this->referenceID = $referenceID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ControlArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
