<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComparisonExpressionType StructType
 * @subpackage Structs
 */
class ComparisonExpressionType extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * @var string
     */
    public $comparisonOperator;
    /**
     * The attributeName
     * @var string
     */
    public $attributeName;
    /**
     * The emptyValue
     * @var \StructType\EmptyValueType
     */
    public $emptyValue;
    /**
     * The instanceValue
     * @var string
     */
    public $instanceValue;
    /**
     * Constructor method for ComparisonExpressionType
     * @uses ComparisonExpressionType::setComparisonOperator()
     * @uses ComparisonExpressionType::setAttributeName()
     * @uses ComparisonExpressionType::setEmptyValue()
     * @uses ComparisonExpressionType::setInstanceValue()
     * @param string $comparisonOperator
     * @param string $attributeName
     * @param \StructType\EmptyValueType $emptyValue
     * @param string $instanceValue
     */
    public function __construct($comparisonOperator = null, $attributeName = null, \StructType\EmptyValueType $emptyValue = null, $instanceValue = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setAttributeName($attributeName)
            ->setEmptyValue($emptyValue)
            ->setInstanceValue($instanceValue);
    }
    /**
     * Get comparisonOperator value
     * @return string|null
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperator::valueIsValid()
     * @uses \EnumType\ComparisonOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\ComparisonExpressionType
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperator::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperator::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get attributeName value
     * @return string|null
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }
    /**
     * Set attributeName value
     * @uses \EnumType\FilterAttributeListDT::valueIsValid()
     * @uses \EnumType\FilterAttributeListDT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributeName
     * @return \StructType\ComparisonExpressionType
     */
    public function setAttributeName($attributeName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FilterAttributeListDT::valueIsValid($attributeName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attributeName, implode(', ', \EnumType\FilterAttributeListDT::getValidValues())), __LINE__);
        }
        $this->attributeName = $attributeName;
        return $this;
    }
    /**
     * Get emptyValue value
     * @return \StructType\EmptyValueType|null
     */
    public function getEmptyValue()
    {
        return $this->emptyValue;
    }
    /**
     * Set emptyValue value
     * @param \StructType\EmptyValueType $emptyValue
     * @return \StructType\ComparisonExpressionType
     */
    public function setEmptyValue(\StructType\EmptyValueType $emptyValue = null)
    {
        $this->emptyValue = $emptyValue;
        return $this;
    }
    /**
     * Get instanceValue value
     * @return string|null
     */
    public function getInstanceValue()
    {
        return $this->instanceValue;
    }
    /**
     * Set instanceValue value
     * @param string $instanceValue
     * @return \StructType\ComparisonExpressionType
     */
    public function setInstanceValue($instanceValue = null)
    {
        // validation for constraint: string
        if (!is_null($instanceValue) && !is_string($instanceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceValue)), __LINE__);
        }
        $this->instanceValue = $instanceValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComparisonExpressionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
