<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Show ServiceType
 * @subpackage Services
 */
class Show extends AbstractSoapClientBase
{
    /**
     * Sets the Activation SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ActivationType $activation
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderActivation(\StructType\ActivationType $activation, $nameSpace = 'http://www.infor.com/businessinterface/WarehouseItemInventory', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Activation', $activation, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Show
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Activation
     * - SOAPHeaderNamespaces: http://www.infor.com/businessinterface/WarehouseItemInventory
     * - SOAPHeaderTypes: \StructType\ActivationType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShowRequestType $showRequest
     * @return \StructType\ShowResponseType|bool
     */
    public function Show(\StructType\ShowRequestType $showRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->Show($showRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShowResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
