<?php

namespace EnumType;

/**
 * This class stands for processingScope EnumType
 * @subpackage Enumerations
 */
class ProcessingScope
{
    /**
     * Constant for value 'not_applicable'
     * @return string 'not_applicable'
     */
    const VALUE_NOT_APPLICABLE = 'not_applicable';
    /**
     * Constant for value 'request'
     * @return string 'request'
     */
    const VALUE_REQUEST = 'request';
    /**
     * Constant for value 'business_entity'
     * @return string 'business_entity'
     */
    const VALUE_BUSINESS_ENTITY = 'business_entity';
    /**
     * Constant for value 'business_entity_component'
     * @return string 'business_entity_component'
     */
    const VALUE_BUSINESS_ENTITY_COMPONENT = 'business_entity_component';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_APPLICABLE
     * @uses self::VALUE_REQUEST
     * @uses self::VALUE_BUSINESS_ENTITY
     * @uses self::VALUE_BUSINESS_ENTITY_COMPONENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_APPLICABLE,
            self::VALUE_REQUEST,
            self::VALUE_BUSINESS_ENTITY,
            self::VALUE_BUSINESS_ENTITY_COMPONENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
