<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseItemInventory StructType
 * @subpackage Structs
 */
class WarehouseItemInventory extends AbstractStructBase
{
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Warehouse;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Item;
    /**
     * The Inventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Inventory[]
     */
    public $Inventory;
    /**
     * The WarehouseDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseDescription;
    /**
     * The ItemDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemDescription;
    /**
     * Constructor method for WarehouseItemInventory
     * @uses WarehouseItemInventory::setWarehouse()
     * @uses WarehouseItemInventory::setItem()
     * @uses WarehouseItemInventory::setInventory()
     * @uses WarehouseItemInventory::setWarehouseDescription()
     * @uses WarehouseItemInventory::setItemDescription()
     * @param string $warehouse
     * @param string $item
     * @param \StructType\Inventory[] $inventory
     * @param string $warehouseDescription
     * @param string $itemDescription
     */
    public function __construct($warehouse = null, $item = null, array $inventory = array(), $warehouseDescription = null, $itemDescription = null)
    {
        $this
            ->setWarehouse($warehouse)
            ->setItem($item)
            ->setInventory($inventory)
            ->setWarehouseDescription($warehouseDescription)
            ->setItemDescription($itemDescription);
    }
    /**
     * Get Warehouse value
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param string $warehouse
     * @return \StructType\WarehouseItemInventory
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouse)), __LINE__);
        }
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param string $item
     * @return \StructType\WarehouseItemInventory
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($item)), __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Inventory value
     * @return \StructType\Inventory[]|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * Set Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory[] $inventory
     * @return \StructType\WarehouseItemInventory
     */
    public function setInventory(array $inventory = array())
    {
        foreach ($inventory as $warehouseItemInventoryInventoryItem) {
            // validation for constraint: itemType
            if (!$warehouseItemInventoryInventoryItem instanceof \StructType\Inventory) {
                throw new \InvalidArgumentException(sprintf('The Inventory property can only contain items of \StructType\Inventory, "%s" given', is_object($warehouseItemInventoryInventoryItem) ? get_class($warehouseItemInventoryInventoryItem) : gettype($warehouseItemInventoryInventoryItem)), __LINE__);
            }
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Add item to Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory $item
     * @return \StructType\WarehouseItemInventory
     */
    public function addToInventory(\StructType\Inventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Inventory) {
            throw new \InvalidArgumentException(sprintf('The Inventory property can only contain items of \StructType\Inventory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Inventory[] = $item;
        return $this;
    }
    /**
     * Get WarehouseDescription value
     * @return string|null
     */
    public function getWarehouseDescription()
    {
        return $this->WarehouseDescription;
    }
    /**
     * Set WarehouseDescription value
     * @param string $warehouseDescription
     * @return \StructType\WarehouseItemInventory
     */
    public function setWarehouseDescription($warehouseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseDescription) && !is_string($warehouseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseDescription)), __LINE__);
        }
        $this->WarehouseDescription = $warehouseDescription;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \StructType\WarehouseItemInventory
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarehouseItemInventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
