<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageDetails StructType
 * @subpackage Structs
 */
class MessageDetails extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DetailMessage[]
     */
    public $Message;
    /**
     * Constructor method for MessageDetails
     * @uses MessageDetails::setMessage()
     * @param \StructType\DetailMessage[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * @return \StructType\DetailMessage[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailMessage[] $message
     * @return \StructType\MessageDetails
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $messageDetailsMessageItem) {
            // validation for constraint: itemType
            if (!$messageDetailsMessageItem instanceof \StructType\DetailMessage) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\DetailMessage, "%s" given', is_object($messageDetailsMessageItem) ? get_class($messageDetailsMessageItem) : gettype($messageDetailsMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailMessage $item
     * @return \StructType\MessageDetails
     */
    public function addToMessage(\StructType\DetailMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailMessage) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \StructType\DetailMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
