<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The messageIndex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $messageIndex;
    /**
     * The messageCode
     * @var string
     */
    public $messageCode;
    /**
     * The messageType
     * @var string
     */
    public $messageType;
    /**
     * The messageText
     * @var string
     */
    public $messageText;
    /**
     * The messageSource
     * @var string
     */
    public $messageSource;
    /**
     * The MessageDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageDetails
     */
    public $MessageDetails;
    /**
     * The messageCorrectiveAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageCorrectiveAction;
    /**
     * The messageAdditionalHelpText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageAdditionalHelpText;
    /**
     * The messageAdditionalHelpURI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageAdditionalHelpURI;
    /**
     * The MessageReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageReference
     */
    public $MessageReference;
    /**
     * Constructor method for Message
     * @uses Message::setMessageIndex()
     * @uses Message::setMessageCode()
     * @uses Message::setMessageType()
     * @uses Message::setMessageText()
     * @uses Message::setMessageSource()
     * @uses Message::setMessageDetails()
     * @uses Message::setMessageCorrectiveAction()
     * @uses Message::setMessageAdditionalHelpText()
     * @uses Message::setMessageAdditionalHelpURI()
     * @uses Message::setMessageReference()
     * @param int $messageIndex
     * @param string $messageCode
     * @param string $messageType
     * @param string $messageText
     * @param string $messageSource
     * @param \StructType\MessageDetails $messageDetails
     * @param string $messageCorrectiveAction
     * @param string $messageAdditionalHelpText
     * @param string $messageAdditionalHelpURI
     * @param \StructType\MessageReference $messageReference
     */
    public function __construct($messageIndex = null, $messageCode = null, $messageType = null, $messageText = null, $messageSource = null, \StructType\MessageDetails $messageDetails = null, $messageCorrectiveAction = null, $messageAdditionalHelpText = null, $messageAdditionalHelpURI = null, \StructType\MessageReference $messageReference = null)
    {
        $this
            ->setMessageIndex($messageIndex)
            ->setMessageCode($messageCode)
            ->setMessageType($messageType)
            ->setMessageText($messageText)
            ->setMessageSource($messageSource)
            ->setMessageDetails($messageDetails)
            ->setMessageCorrectiveAction($messageCorrectiveAction)
            ->setMessageAdditionalHelpText($messageAdditionalHelpText)
            ->setMessageAdditionalHelpURI($messageAdditionalHelpURI)
            ->setMessageReference($messageReference);
    }
    /**
     * Get messageIndex value
     * @return int|null
     */
    public function getMessageIndex()
    {
        return $this->messageIndex;
    }
    /**
     * Set messageIndex value
     * @param int $messageIndex
     * @return \StructType\Message
     */
    public function setMessageIndex($messageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($messageIndex) && !is_numeric($messageIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageIndex)), __LINE__);
        }
        $this->messageIndex = $messageIndex;
        return $this;
    }
    /**
     * Get messageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->messageCode;
    }
    /**
     * Set messageCode value
     * @param string $messageCode
     * @return \StructType\Message
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageCode)), __LINE__);
        }
        $this->messageCode = $messageCode;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\Message
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $messageType, implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \StructType\Message
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get messageSource value
     * @return string|null
     */
    public function getMessageSource()
    {
        return $this->messageSource;
    }
    /**
     * Set messageSource value
     * @param string $messageSource
     * @return \StructType\Message
     */
    public function setMessageSource($messageSource = null)
    {
        // validation for constraint: string
        if (!is_null($messageSource) && !is_string($messageSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageSource)), __LINE__);
        }
        $this->messageSource = $messageSource;
        return $this;
    }
    /**
     * Get MessageDetails value
     * @return \StructType\MessageDetails|null
     */
    public function getMessageDetails()
    {
        return $this->MessageDetails;
    }
    /**
     * Set MessageDetails value
     * @param \StructType\MessageDetails $messageDetails
     * @return \StructType\Message
     */
    public function setMessageDetails(\StructType\MessageDetails $messageDetails = null)
    {
        $this->MessageDetails = $messageDetails;
        return $this;
    }
    /**
     * Get messageCorrectiveAction value
     * @return string|null
     */
    public function getMessageCorrectiveAction()
    {
        return $this->messageCorrectiveAction;
    }
    /**
     * Set messageCorrectiveAction value
     * @param string $messageCorrectiveAction
     * @return \StructType\Message
     */
    public function setMessageCorrectiveAction($messageCorrectiveAction = null)
    {
        // validation for constraint: string
        if (!is_null($messageCorrectiveAction) && !is_string($messageCorrectiveAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageCorrectiveAction)), __LINE__);
        }
        $this->messageCorrectiveAction = $messageCorrectiveAction;
        return $this;
    }
    /**
     * Get messageAdditionalHelpText value
     * @return string|null
     */
    public function getMessageAdditionalHelpText()
    {
        return $this->messageAdditionalHelpText;
    }
    /**
     * Set messageAdditionalHelpText value
     * @param string $messageAdditionalHelpText
     * @return \StructType\Message
     */
    public function setMessageAdditionalHelpText($messageAdditionalHelpText = null)
    {
        // validation for constraint: string
        if (!is_null($messageAdditionalHelpText) && !is_string($messageAdditionalHelpText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageAdditionalHelpText)), __LINE__);
        }
        $this->messageAdditionalHelpText = $messageAdditionalHelpText;
        return $this;
    }
    /**
     * Get messageAdditionalHelpURI value
     * @return string|null
     */
    public function getMessageAdditionalHelpURI()
    {
        return $this->messageAdditionalHelpURI;
    }
    /**
     * Set messageAdditionalHelpURI value
     * @param string $messageAdditionalHelpURI
     * @return \StructType\Message
     */
    public function setMessageAdditionalHelpURI($messageAdditionalHelpURI = null)
    {
        // validation for constraint: string
        if (!is_null($messageAdditionalHelpURI) && !is_string($messageAdditionalHelpURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageAdditionalHelpURI)), __LINE__);
        }
        $this->messageAdditionalHelpURI = $messageAdditionalHelpURI;
        return $this;
    }
    /**
     * Get MessageReference value
     * @return \StructType\MessageReference|null
     */
    public function getMessageReference()
    {
        return $this->MessageReference;
    }
    /**
     * Set MessageReference value
     * @param \StructType\MessageReference $messageReference
     * @return \StructType\Message
     */
    public function setMessageReference(\StructType\MessageReference $messageReference = null)
    {
        $this->MessageReference = $messageReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
