<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterType StructType
 * @subpackage Structs
 */
class FilterType extends AbstractStructBase
{
    /**
     * The LogicalExpression
     * @var \StructType\LogicalExpressionType
     */
    public $LogicalExpression;
    /**
     * The ComparisonExpression
     * @var \StructType\ComparisonExpressionType
     */
    public $ComparisonExpression;
    /**
     * Constructor method for FilterType
     * @uses FilterType::setLogicalExpression()
     * @uses FilterType::setComparisonExpression()
     * @param \StructType\LogicalExpressionType $logicalExpression
     * @param \StructType\ComparisonExpressionType $comparisonExpression
     */
    public function __construct(\StructType\LogicalExpressionType $logicalExpression = null, \StructType\ComparisonExpressionType $comparisonExpression = null)
    {
        $this
            ->setLogicalExpression($logicalExpression)
            ->setComparisonExpression($comparisonExpression);
    }
    /**
     * Get LogicalExpression value
     * @return \StructType\LogicalExpressionType|null
     */
    public function getLogicalExpression()
    {
        return $this->LogicalExpression;
    }
    /**
     * Set LogicalExpression value
     * @param \StructType\LogicalExpressionType $logicalExpression
     * @return \StructType\FilterType
     */
    public function setLogicalExpression(\StructType\LogicalExpressionType $logicalExpression = null)
    {
        $this->LogicalExpression = $logicalExpression;
        return $this;
    }
    /**
     * Get ComparisonExpression value
     * @return \StructType\ComparisonExpressionType|null
     */
    public function getComparisonExpression()
    {
        return $this->ComparisonExpression;
    }
    /**
     * Set ComparisonExpression value
     * @param \StructType\ComparisonExpressionType $comparisonExpression
     * @return \StructType\FilterType
     */
    public function setComparisonExpression(\StructType\ComparisonExpressionType $comparisonExpression = null)
    {
        $this->ComparisonExpression = $comparisonExpression;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FilterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
