<?php

namespace EnumType;

/**
 * This class stands for comparisonOperator EnumType
 * @subpackage Enumerations
 */
class ComparisonOperator
{
    /**
     * Constant for value 'le'
     * @return string 'le'
     */
    const VALUE_LE = 'le';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'ge'
     * @return string 'ge'
     */
    const VALUE_GE = 'ge';
    /**
     * Constant for value 'gt'
     * @return string 'gt'
     */
    const VALUE_GT = 'gt';
    /**
     * Constant for value 'ne'
     * @return string 'ne'
     */
    const VALUE_NE = 'ne';
    /**
     * Constant for value 'eq'
     * @return string 'eq'
     */
    const VALUE_EQ = 'eq';
    /**
     * Constant for value 'like'
     * @return string 'like'
     */
    const VALUE_LIKE = 'like';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LE
     * @uses self::VALUE_LT
     * @uses self::VALUE_GE
     * @uses self::VALUE_GT
     * @uses self::VALUE_NE
     * @uses self::VALUE_EQ
     * @uses self::VALUE_LIKE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LE,
            self::VALUE_LT,
            self::VALUE_GE,
            self::VALUE_GT,
            self::VALUE_NE,
            self::VALUE_EQ,
            self::VALUE_LIKE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
