<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \InforItem\Item_ClassMap::get(),
);
/**
 * Samples for List ServiceType
 */
$list = new \InforItem\Item_List($options);
$list->setSoapHeaderActivation($Activation);
/**
 * Sample call for _List operation/method
 */
if ($list->_List(new \InforItem\Item_ListRequestType()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Show ServiceType
 */
$show = new \InforItem\Item_Show($options);
$show->setSoapHeaderActivation($Activation);
/**
 * Sample call for Show operation/method
 */
if ($show->Show(new \InforItem\Item_ShowRequestType()) !== false) {
    print_r($show->getResult());
} else {
    print_r($show->getLastError());
}
