<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Show ServiceType
 * @package Item_
 * @subpackage Services
 */
class Item_Show extends AbstractSoapClientBase
{
    /**
     * Sets the Activation SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \InforItem\Item_ActivationType $activation
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderActivation(\InforItem\Item_ActivationType $activation, $nameSpace = 'http://www.infor.com/businessinterface/ProductLine', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Activation', $activation, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Show
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Activation
     * - SOAPHeaderNamespaces: http://www.infor.com/businessinterface/ProductLine
     * - SOAPHeaderTypes: \InforItem\Item_ActivationType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \InforItem\Item_ShowRequestType $showRequest
     * @return \InforItem\Item_ShowResponseType|bool
     */
    public function Show(\InforItem\Item_ShowRequestType $showRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->Show($showRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \InforItem\Item_ShowResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
