<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionType StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_SelectionType extends AbstractStructBase
{
    /**
     * The selectionAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $selectionAttribute;
    /**
     * Constructor method for SelectionType
     * @uses Item_SelectionType::setSelectionAttribute()
     * @param string[] $selectionAttribute
     */
    public function __construct(array $selectionAttribute = array())
    {
        $this
            ->setSelectionAttribute($selectionAttribute);
    }
    /**
     * Get selectionAttribute value
     * @return string[]|null
     */
    public function getSelectionAttribute()
    {
        return $this->selectionAttribute;
    }
    /**
     * Set selectionAttribute value
     * @uses \InforItem\Item_SelectionAttribute::valueIsValid()
     * @uses \InforItem\Item_SelectionAttribute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $selectionAttribute
     * @return \InforItem\Item_SelectionType
     */
    public function setSelectionAttribute(array $selectionAttribute = array())
    {
        $invalidValues = array();
        foreach ($selectionAttribute as $selectionTypeSelectionAttributeItem) {
            if (!\InforItem\Item_SelectionAttribute::valueIsValid($selectionTypeSelectionAttributeItem)) {
                $invalidValues[] = var_export($selectionTypeSelectionAttributeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \InforItem\Item_SelectionAttribute::getValidValues())), __LINE__);
        }
        $this->selectionAttribute = $selectionAttribute;
        return $this;
    }
    /**
     * Add item to selectionAttribute value
     * @uses \InforItem\Item_SelectionAttribute::valueIsValid()
     * @uses \InforItem\Item_SelectionAttribute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \InforItem\Item_SelectionType
     */
    public function addToSelectionAttribute($item)
    {
        // validation for constraint: enumeration
        if (!\InforItem\Item_SelectionAttribute::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \InforItem\Item_SelectionAttribute::getValidValues())), __LINE__);
        }
        $this->selectionAttribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_SelectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
