<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductLine StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_ProductLine extends AbstractStructBase
{
    /**
     * The productLineCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - maxLength: 6
     * @var string
     */
    public $productLineCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $description;
    /**
     * Constructor method for ProductLine
     * @uses Item_ProductLine::setProductLineCode()
     * @uses Item_ProductLine::setDescription()
     * @param string $productLineCode
     * @param string $description
     */
    public function __construct($productLineCode = null, $description = null)
    {
        $this
            ->setProductLineCode($productLineCode)
            ->setDescription($description);
    }
    /**
     * Get productLineCode value
     * @return string
     */
    public function getProductLineCode()
    {
        return $this->productLineCode;
    }
    /**
     * Set productLineCode value
     * @param string $productLineCode
     * @return \InforItem\Item_ProductLine
     */
    public function setProductLineCode($productLineCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productLineCode) && strlen($productLineCode) > 6) || (is_array($productLineCode) && count($productLineCode) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($productLineCode) ? strlen($productLineCode) : count($productLineCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productLineCode) && !is_string($productLineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productLineCode)), __LINE__);
        }
        $this->productLineCode = $productLineCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \InforItem\Item_ProductLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 30) || (is_array($description) && count($description) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_ProductLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
