<?php

namespace InforItem;

/**
 * This class stands for messageType EnumType
 * @package Item_
 * @subpackage Enumerations
 */
class Item_MessageType
{
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Information'
     * @return string 'Information'
     */
    const VALUE_INFORMATION = 'Information';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERROR,
            self::VALUE_WARNING,
            self::VALUE_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
