<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageReference StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_MessageReference extends AbstractStructBase
{
    /**
     * The messageReferenceType
     * @var string
     */
    public $messageReferenceType;
    /**
     * The messageReferenceInfo
     * @var string
     */
    public $messageReferenceInfo;
    /**
     * Constructor method for MessageReference
     * @uses Item_MessageReference::setMessageReferenceType()
     * @uses Item_MessageReference::setMessageReferenceInfo()
     * @param string $messageReferenceType
     * @param string $messageReferenceInfo
     */
    public function __construct($messageReferenceType = null, $messageReferenceInfo = null)
    {
        $this
            ->setMessageReferenceType($messageReferenceType)
            ->setMessageReferenceInfo($messageReferenceInfo);
    }
    /**
     * Get messageReferenceType value
     * @return string|null
     */
    public function getMessageReferenceType()
    {
        return $this->messageReferenceType;
    }
    /**
     * Set messageReferenceType value
     * @param string $messageReferenceType
     * @return \InforItem\Item_MessageReference
     */
    public function setMessageReferenceType($messageReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($messageReferenceType) && !is_string($messageReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReferenceType)), __LINE__);
        }
        $this->messageReferenceType = $messageReferenceType;
        return $this;
    }
    /**
     * Get messageReferenceInfo value
     * @return string|null
     */
    public function getMessageReferenceInfo()
    {
        return $this->messageReferenceInfo;
    }
    /**
     * Set messageReferenceInfo value
     * @param string $messageReferenceInfo
     * @return \InforItem\Item_MessageReference
     */
    public function setMessageReferenceInfo($messageReferenceInfo = null)
    {
        // validation for constraint: string
        if (!is_null($messageReferenceInfo) && !is_string($messageReferenceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReferenceInfo)), __LINE__);
        }
        $this->messageReferenceInfo = $messageReferenceInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_MessageReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
