<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageDetails StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_MessageDetails extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \InforItem\Item_DetailMessage[]
     */
    public $Message;
    /**
     * Constructor method for MessageDetails
     * @uses Item_MessageDetails::setMessage()
     * @param \InforItem\Item_DetailMessage[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * @return \InforItem\Item_DetailMessage[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_DetailMessage[] $message
     * @return \InforItem\Item_MessageDetails
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $messageDetailsMessageItem) {
            // validation for constraint: itemType
            if (!$messageDetailsMessageItem instanceof \InforItem\Item_DetailMessage) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \InforItem\Item_DetailMessage, "%s" given', is_object($messageDetailsMessageItem) ? get_class($messageDetailsMessageItem) : gettype($messageDetailsMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_DetailMessage $item
     * @return \InforItem\Item_MessageDetails
     */
    public function addToMessage(\InforItem\Item_DetailMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InforItem\Item_DetailMessage) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \InforItem\Item_DetailMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_MessageDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
