<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogicalExpressionType StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_LogicalExpressionType extends AbstractStructBase
{
    /**
     * The logicalOperator
     * @var string
     */
    public $logicalOperator;
    /**
     * The LogicalExpression
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \InforItem\Item_LogicalExpressionType[]
     */
    public $LogicalExpression;
    /**
     * The ComparisonExpression
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \InforItem\Item_ComparisonExpressionType[]
     */
    public $ComparisonExpression;
    /**
     * Constructor method for LogicalExpressionType
     * @uses Item_LogicalExpressionType::setLogicalOperator()
     * @uses Item_LogicalExpressionType::setLogicalExpression()
     * @uses Item_LogicalExpressionType::setComparisonExpression()
     * @param string $logicalOperator
     * @param \InforItem\Item_LogicalExpressionType[] $logicalExpression
     * @param \InforItem\Item_ComparisonExpressionType[] $comparisonExpression
     */
    public function __construct($logicalOperator = null, array $logicalExpression = array(), array $comparisonExpression = array())
    {
        $this
            ->setLogicalOperator($logicalOperator)
            ->setLogicalExpression($logicalExpression)
            ->setComparisonExpression($comparisonExpression);
    }
    /**
     * Get logicalOperator value
     * @return string|null
     */
    public function getLogicalOperator()
    {
        return $this->logicalOperator;
    }
    /**
     * Set logicalOperator value
     * @uses \InforItem\Item_LogicalOperator::valueIsValid()
     * @uses \InforItem\Item_LogicalOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalOperator
     * @return \InforItem\Item_LogicalExpressionType
     */
    public function setLogicalOperator($logicalOperator = null)
    {
        // validation for constraint: enumeration
        if (!\InforItem\Item_LogicalOperator::valueIsValid($logicalOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalOperator, implode(', ', \InforItem\Item_LogicalOperator::getValidValues())), __LINE__);
        }
        $this->logicalOperator = $logicalOperator;
        return $this;
    }
    /**
     * Get LogicalExpression value
     * @return \InforItem\Item_LogicalExpressionType[]|null
     */
    public function getLogicalExpression()
    {
        return $this->LogicalExpression;
    }
    /**
     * Set LogicalExpression value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_LogicalExpressionType[] $logicalExpression
     * @return \InforItem\Item_LogicalExpressionType
     */
    public function setLogicalExpression(array $logicalExpression = array())
    {
        foreach ($logicalExpression as $logicalExpressionTypeLogicalExpressionItem) {
            // validation for constraint: itemType
            if (!$logicalExpressionTypeLogicalExpressionItem instanceof \InforItem\Item_LogicalExpressionType) {
                throw new \InvalidArgumentException(sprintf('The LogicalExpression property can only contain items of \InforItem\Item_LogicalExpressionType, "%s" given', is_object($logicalExpressionTypeLogicalExpressionItem) ? get_class($logicalExpressionTypeLogicalExpressionItem) : gettype($logicalExpressionTypeLogicalExpressionItem)), __LINE__);
            }
        }
        $this->LogicalExpression = $logicalExpression;
        return $this;
    }
    /**
     * Add item to LogicalExpression value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_LogicalExpressionType $item
     * @return \InforItem\Item_LogicalExpressionType
     */
    public function addToLogicalExpression(\InforItem\Item_LogicalExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InforItem\Item_LogicalExpressionType) {
            throw new \InvalidArgumentException(sprintf('The LogicalExpression property can only contain items of \InforItem\Item_LogicalExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LogicalExpression[] = $item;
        return $this;
    }
    /**
     * Get ComparisonExpression value
     * @return \InforItem\Item_ComparisonExpressionType[]|null
     */
    public function getComparisonExpression()
    {
        return $this->ComparisonExpression;
    }
    /**
     * Set ComparisonExpression value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_ComparisonExpressionType[] $comparisonExpression
     * @return \InforItem\Item_LogicalExpressionType
     */
    public function setComparisonExpression(array $comparisonExpression = array())
    {
        foreach ($comparisonExpression as $logicalExpressionTypeComparisonExpressionItem) {
            // validation for constraint: itemType
            if (!$logicalExpressionTypeComparisonExpressionItem instanceof \InforItem\Item_ComparisonExpressionType) {
                throw new \InvalidArgumentException(sprintf('The ComparisonExpression property can only contain items of \InforItem\Item_ComparisonExpressionType, "%s" given', is_object($logicalExpressionTypeComparisonExpressionItem) ? get_class($logicalExpressionTypeComparisonExpressionItem) : gettype($logicalExpressionTypeComparisonExpressionItem)), __LINE__);
            }
        }
        $this->ComparisonExpression = $comparisonExpression;
        return $this;
    }
    /**
     * Add item to ComparisonExpression value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_ComparisonExpressionType $item
     * @return \InforItem\Item_LogicalExpressionType
     */
    public function addToComparisonExpression(\InforItem\Item_ComparisonExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InforItem\Item_ComparisonExpressionType) {
            throw new \InvalidArgumentException(sprintf('The ComparisonExpression property can only contain items of \InforItem\Item_ComparisonExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ComparisonExpression[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_LogicalExpressionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
