<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @package Item_
 * @subpackage Services
 */
class Item_List extends AbstractSoapClientBase
{
    /**
     * Sets the Activation SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \InforItem\Item_ActivationType $activation
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderActivation(\InforItem\Item_ActivationType $activation, $nameSpace = 'http://www.infor.com/businessinterface/ProductLine', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Activation', $activation, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named List
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Activation
     * - SOAPHeaderNamespaces: http://www.infor.com/businessinterface/ProductLine
     * - SOAPHeaderTypes: \InforItem\Item_ActivationType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \InforItem\Item_ListRequestType $listRequest
     * @return \InforItem\Item_ListResponseType|bool
     */
    public function _List(\InforItem\Item_ListRequestType $listRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->List($listRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \InforItem\Item_ListResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
