<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationArea StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_InformationArea extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \InforItem\Item_InformationMessage[]
     */
    public $Message;
    /**
     * Constructor method for InformationArea
     * @uses Item_InformationArea::setMessage()
     * @param \InforItem\Item_InformationMessage[] $message
     */
    public function __construct(array $message = array())
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get Message value
     * @return \InforItem\Item_InformationMessage[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_InformationMessage[] $message
     * @return \InforItem\Item_InformationArea
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $informationAreaMessageItem) {
            // validation for constraint: itemType
            if (!$informationAreaMessageItem instanceof \InforItem\Item_InformationMessage) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \InforItem\Item_InformationMessage, "%s" given', is_object($informationAreaMessageItem) ? get_class($informationAreaMessageItem) : gettype($informationAreaMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \InforItem\Item_InformationMessage $item
     * @return \InforItem\Item_InformationArea
     */
    public function addToMessage(\InforItem\Item_InformationMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InforItem\Item_InformationMessage) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \InforItem\Item_InformationMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_InformationArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
