<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterType StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_FilterType extends AbstractStructBase
{
    /**
     * The LogicalExpression
     * @var \InforItem\Item_LogicalExpressionType
     */
    public $LogicalExpression;
    /**
     * The ComparisonExpression
     * @var \InforItem\Item_ComparisonExpressionType
     */
    public $ComparisonExpression;
    /**
     * Constructor method for FilterType
     * @uses Item_FilterType::setLogicalExpression()
     * @uses Item_FilterType::setComparisonExpression()
     * @param \InforItem\Item_LogicalExpressionType $logicalExpression
     * @param \InforItem\Item_ComparisonExpressionType $comparisonExpression
     */
    public function __construct(\InforItem\Item_LogicalExpressionType $logicalExpression = null, \InforItem\Item_ComparisonExpressionType $comparisonExpression = null)
    {
        $this
            ->setLogicalExpression($logicalExpression)
            ->setComparisonExpression($comparisonExpression);
    }
    /**
     * Get LogicalExpression value
     * @return \InforItem\Item_LogicalExpressionType|null
     */
    public function getLogicalExpression()
    {
        return $this->LogicalExpression;
    }
    /**
     * Set LogicalExpression value
     * @param \InforItem\Item_LogicalExpressionType $logicalExpression
     * @return \InforItem\Item_FilterType
     */
    public function setLogicalExpression(\InforItem\Item_LogicalExpressionType $logicalExpression = null)
    {
        $this->LogicalExpression = $logicalExpression;
        return $this;
    }
    /**
     * Get ComparisonExpression value
     * @return \InforItem\Item_ComparisonExpressionType|null
     */
    public function getComparisonExpression()
    {
        return $this->ComparisonExpression;
    }
    /**
     * Set ComparisonExpression value
     * @param \InforItem\Item_ComparisonExpressionType $comparisonExpression
     * @return \InforItem\Item_FilterType
     */
    public function setComparisonExpression(\InforItem\Item_ComparisonExpressionType $comparisonExpression = null)
    {
        $this->ComparisonExpression = $comparisonExpression;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_FilterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
